##############################################################################
#
#  Vim Shell Command Injection Vulnerability (Linux)
#
#  Copyright: SecPod
#
#  Date Written: 2008/12/02
#
#  Revision: 1.0
#
#  Log: sghosal
#  Issue #0546
#
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
##############################################################################

if(description)
{
  script_id(900412);
  script_bugtraq_id(32462);
  script_cve_id("CVE-2008-2712", "CVE-2008-3074", "CVE-2008-3075", "CVE-2008-3076");
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Misc.");
  script_name(english:"Vim Shell Command Injection Vulnerability (Linux)");
  script_summary(english:"Check for vulnerable version of Vim");
  desc["english"] = "
  Overview: This host is installed with Vim and is prone to Command Injection
  Vulnerability.

  Vulnerability Insight:
  This error is caused due to the 'filetype.vim', 'tar.vim', 'zip.vim', 'xpm.vim',
  'xpm2.vim', 'gzip.vim', and 'netrw.vim' scripts whcih are insufficiently
  filtering special characters.

  Impact:
  Successful exploitation will let the attacker execute arbitrary shell commands
  to compromise the system.

  Impact Level: Application

  Affected Software/OS:
  Vim version prior to 7.2 on Linux.

  Fix: Upgrade to version 7.2
  http://www.vim.org/download.php

  References:
  http://secunia.com/advisories/30731/
  http://www.rdancer.org/vulnerablevim-shellescape.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(english:desc["english"]);
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/uname");
  exit(0);
}


include("ssh_func.inc");

if("Linux" >!< get_kb_item("ssh/login/uname")){
  exit(0);
}

sock = ssh_login_or_reuse_connection();
if(sock)
{
  vimVer = ssh_cmd(socket:sock, cmd:"vim --version", timeout:120);
  ssh_close_connection();
  if("VIM" >< vimVer){
    pattern = "Vi IMproved ([0-6](\..*)?|7\.[01](\..*)?)";
    if(egrep(pattern:pattern, string:vimVer)){
      security_warning(0);
    }
  }
}
