###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_winasm_studio_wap_bof_vuln.nasl 1087 2009-03-25 10:34:01Z mar $
#
# WinAsm Studio Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900532);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1040");
  script_bugtraq_id(34132);
  script_name(english:"WinAsm Studio Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview: This host is running WinAsm Studio and is prone to Heap Overflow
  Vulnerability.

  Vulnerability Insight:
  Improper boundary checking while handling project files which leads to
  heap overflow while processing crafted '.wap' files.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in
  the context of the application to cause heap overflow.

  Impact level: System/Application

  Affected Software/OS:
  WinAsm Studio version 5.1.5.0 and prior.

  Fix: No solution or patch is available as on 26th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.winasm.net

  References:
  http://secunia.com/advisories/34309
  http://www.milw0rm.com/exploits/8224
  http://xforce.iss.net/xforce/xfdb/49266

  CVSS Score:
    CVSS Base Score     : 9.0 (AV:N/AC:L/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 8.1
  Risk factor: Critical";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of WinAsm Studio");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

progDir = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion\",
                           item:"ProgramFilesDir");
if(!progDir){
  exit(0);
}

winasmPath1 = progDir + "\WinAsm\WinAsm.exe";
winasmPath2 = progDir - "Program Files" + "\WinAsm\WinAsm.exe";

foreach path (make_list(winasmPath1, winasmPath2))
{
  share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$",string:path);
  file = ereg_replace(pattern:"[A-Z]:(.*)",replace:"\1",string:path);
  version = GetVer(file:file, share:share);
  if(version != NULL)
  {
    if(version_is_less_equal(version:version, test_version:"5.1.5.0")){
      security_hole(0);
    }
    exit(0);
  }
}
