###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_xpdf_detect.nasl 1933 2009-04-27 14:10:29Z apr $
#
# Xpdf Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900466);
  script_version("$Revision: 1.0 $");
  script_name(english:"Xpdf Version Detection");
  desc["english"] = "

  Overview: The script detects the version of Xpdf for Linux on
  remote host and sets the result into KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Check for Linux Xpdf version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Service detection");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

xpdfPaths = find_file(file_name:"xpdf", file_path:"/", useregex:TRUE,
                       regexpar:"$", sock:sock);
foreach xpdfBin (xpdfPaths)
{
  xpdfVer = get_bin_version(full_prog_name:chomp(xpdfBin), sock:sock,
                            version_argv:"-v",
                            ver_pattern:"xpdf version ([0-9]\.[0-9]+([a-z]?))");
  if(xpdfVer[1] != NULL)
  {
    set_kb_item(name:"Xpdf/Linux/Ver", value:xpdfVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
