#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 01 $

if(description)
{

 script_id(90019);
 script_version ("$Revision: 01 $");
 name["english"] = "Adobe Flash Player 9.0.115.0 and earlier vulnerability (Win)";
 script_name(english:name["english"]);

 desc["english"] = "The remote host is probably affected by the vulnerabilities described in
CVE-2007-5275, CVE-2007-6019, CVE-2007-6243, CVE-2007-6637, CVE-2008-1654, CVE-2008-1655

Impact
   CVE 2007-5275
     The Adobe Macromedia Flash 9 plug-in allows remote attackers to cause
     a victim machine to establish TCP sessions with arbitrary hosts via a
     Flash (SWF) movie, related to lack of pinning of a hostname to a single
     IP address after receiving an allow-access-from element in a 
     cross-domain-policy XML document, and the availability of a Flash Socket
     class that does not use the browser's DNS pins, aka DNS rebinding attacks,
     a different issue than CVE-2002-1467 and CVE-2007-4324.
   CVE 2007-6019
     Adobe Flash Player 9.0.115.0 and earlier, and 8.0.39.0 and earlier,
     allows remote attackers to execute arbitrary code via an SWF file with
     a modified DeclareFunction2 Actionscript tag, which prevents an object
     from being instantiated properly.
   CVE 2007-6243
     Adobe Flash Player 9.x up to 9.0.48.0, 8.x up to 8.0.35.0, and 7.x 
     up to 7.0.70.0 does not sufficiently restrict the interpretation and 
     usage of cross-domain policy files, which makes it easier for remote 
     attackers to conduct cross-domain and cross-site scripting (XSS) attacks. 
   CVE 2007-6637
     Multiple cross-site scripting (XSS) vulnerabilities in Adobe Flash 
     Player allow remote attackers to inject arbitrary web script or HTML
     via a crafted SWF file, related to 'pre-generated SWF files' and Adobe
     Dreamweaver CS3 or Adobe Acrobat Connect. NOTE: the asfunction: vector
     is already covered by CVE-2007-6244.1. 
   CVE 2008-1654
     Interaction error between Adobe Flash and multiple Universal Plug and Play
     (UPnP) services allow remote attackers to perform Cross-Site Request 
     Forgery (CSRF) style attacks by using the Flash navigateToURL function
     to send a SOAP message to a UPnP control point, as demonstrated by changing
     the primary DNS server. 
   CVE 2008-1655
     Unspecified vulnerability in Adobe Flash Player 9.0.115.0 and earlier,
     and 8.0.39.0 and earlier, makes it easier for remote attackers to 
     conduct DNS rebinding attacks via unknown vectors. 


References:
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5275
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6019
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6243
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6637
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1654
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1655

Solution:
    All Adobe Flash Player users should upgrade to the latest version:


Risk factor : High
";

 script_description(english:desc["english"]);
 summary["english"] = "Determines the Version of Flashplayer";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is under GPLv2");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 exit(0);
}

#
# The code starts here
#

include("version_func.inc");
include("smbcl_func.inc");
if( check_smbcl() == 0 ) exit(0);

  sec_hole = 0;
  test_version = "9.0.115.0";
  win_dir = get_windir();
  if( !isnull(win_dir) ) {
    test_file[0] = win_dir+"System32\Macromed\Flash\NPSWF32.dll";
    test_file[1] = win_dir+"System32\Macromed\Flash\Flash.ocx";
    test_file[2] = win_dir+"System32\Macromed\Flash\Flash6.ocx";
    foreach filespec (test_file) {
      r = smbgetdir(share: "C$", dir: filespec, typ: 1 );
      if( !isnull(r) ) {
          tmp_filename = get_tmp_dir()+"tmpfile"+rand();
          if( smbgetfile(share: "C$", filename: filespec, tmp_filename: tmp_filename) ) {
            v = GetPEFileVersion(tmp_filename:tmp_filename, orig_filename:filespec);
            unlink(tmp_filename);
            if( version_is_less_equal(version: v, test_version: test_version) ) {
              if( sec_hole == 0 ) {
                security_hole(port:0, proto:"Win_Flashplayer");
                sec_hole = 1;
              }
              security_hole(port:0, proto:"Win_Flashplayer", data:"Fileversion : C$ "+filespec + " "+v+string("\n"));
            }
          } else {
            report = string("Error getting SMB-File -> "+get_kb_item("SMB/ERROR")) + string("\n");
            security_note(port:0, proto:"Win_Flashplayer", data:report);
          }
      }
    }
  }

exit(0);
