# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SA:2009:005 (bind)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63274);
 script_cve_id("CVE-2009-0025");
 script_version ("$");
 name["english"] = "SuSE Security Advisory SUSE-SA:2009:005 (bind)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory SUSE-SA:2009:005.

The DNS daemon bind is used to resolve and lookup addresses on the
internet.  Some month ago a vulnerability in the DNS protocol and
its numbers was published that allowed easy spoofing of DNS entries.
The only way to protect against spoofing is to use DNSSEC.
Unfortunately the bind code that verifys the certification chain of a DNS-
SEC zone transfer does not properly check the return value of function
DSA_do_verify(). This allows the spoofing of records signed with DSA or
NSEC3DSA.

Solution:
Update your system with the packages as indicated in
the referenced security advisory.

https://secure1.securityspace.com/smysecure/catid.html?in=SUSE-SA:2009:005

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "SuSE Security Advisory SUSE-SA:2009:005 (bind)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.5.0P2~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-debugsource", rpm:"bind-debugsource~9.5.0P2~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.5.0P2~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.5.0P2~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.5.0P2~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.5.0P2~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.5.0P2~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.5.0P2~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-debugsource", rpm:"bind-debugsource~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.5.0P2~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
