# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SR:2009:003
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63304);
 script_cve_id("CVE-2008-1149", "CVE-2008-1567", "CVE-2008-1924", "CVE-2008-2383", "CVE-2008-2960", "CVE-2008-3197", "CVE-2008-4096", "CVE-2008-4309", "CVE-2008-4326", "CVE-2008-5081", "CVE-2008-5432", "CVE-2008-5621", "CVE-2008-5622", "CVE-2008-5824", "CVE-2008-5902", "CVE-2008-5903", "CVE-2008-5904", "CVE-2008-5907", "CVE-2009-0125", "CVE-2009-0126", "CVE-2009-0135", "CVE-2009-0136", "CVE-2009-0034");
 script_version ("$");
 name["english"] = "SuSE Security Summary SUSE-SR:2009:003";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory SUSE-SR:2009:003.  SuSE Security Summaries are short
on detail when it comes to the names of packages affected by
a particular bug. Because of this, while this test will detect
out of date packages, it cannot tell you what bugs impact
which packages, or vice versa.

Solution:

Update all out of date packages.

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "SuSE Security Advisory SUSE-SR:2009:003";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"amarok", rpm:"amarok~1.4.10~26.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-lang", rpm:"amarok-lang~1.4.10~26.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-libvisual", rpm:"amarok-libvisual~1.4.10~26.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-xine", rpm:"amarok-xine~1.4.10~26.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-yauap", rpm:"amarok-yauap~1.4.10~26.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi", rpm:"at-spi~1.24.0~2.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi-devel", rpm:"at-spi-devel~1.24.0~2.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi-doc", rpm:"at-spi-doc~1.24.0~2.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi-lang", rpm:"at-spi-lang~1.24.0~2.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"attr", rpm:"attr~2.4.43~2.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audiofile", rpm:"audiofile~0.2.6~140.18.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audiofile-devel", rpm:"audiofile-devel~0.2.6~140.18.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"autofs", rpm:"autofs~5.0.3~82.28.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi", rpm:"avahi~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-howl-devel", rpm:"avahi-compat-howl-devel~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-mDNSResponder-devel", rpm:"avahi-compat-mDNSResponder-devel~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-utils", rpm:"avahi-utils~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"backup-manager", rpm:"backup-manager~0.1.0~13.12.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"backup-manager-lang", rpm:"backup-manager-lang~0.1.0~13.12.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"brasero", rpm:"brasero~0.8.3~1.18.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"brasero-doc", rpm:"brasero-doc~0.8.3~1.18.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"brasero-lang", rpm:"brasero-lang~0.8.3~1.18.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compat-openssl097g", rpm:"compat-openssl097g~0.9.7g~145.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"crash", rpm:"crash~4.0.7.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"crash-devel", rpm:"crash-devel~4.0.7.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"crash-doc", rpm:"crash-doc~4.0.7.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"crash-sial", rpm:"crash-sial~4.0.7.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-main-menu", rpm:"gnome-main-menu~0.9.11~22.9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2", rpm:"gtk2~2.14.4~6.4.5", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-branding-upstream", rpm:"gtk2-branding-upstream~2.14.4~6.4.5", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-devel", rpm:"gtk2-devel~2.14.4~6.4.5", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-doc", rpm:"gtk2-doc~2.14.4~6.4.5", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-lang", rpm:"gtk2-lang~2.14.4~6.4.5", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal", rpm:"hal~0.5.12~10.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal-devel", rpm:"hal-devel~0.5.12~10.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libattr", rpm:"libattr~2.4.43~2.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libattr-devel", rpm:"libattr-devel~2.4.43~2.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-client3", rpm:"libavahi-client3~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-common3", rpm:"libavahi-common3~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-core5", rpm:"libavahi-core5~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-devel", rpm:"libavahi-devel~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-glib-devel", rpm:"libavahi-glib-devel~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-glib1", rpm:"libavahi-glib1~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-gobject-devel", rpm:"libavahi-gobject-devel~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-gobject0", rpm:"libavahi-gobject0~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-ui0", rpm:"libavahi-ui0~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libdns_sd", rpm:"libdns_sd~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libhowl0", rpm:"libhowl0~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl-devel", rpm:"libopenssl-devel~0.9.8h~28.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl0_9_8", rpm:"libopenssl0_9_8~0.9.8h~28.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.31~4.35.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.31~4.35.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng12-0", rpm:"libpng12-0~1.2.31~4.35.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.7.1~8.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.7.1~8.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-doc", rpm:"libxml2-doc~2.7.1~8.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mailman", rpm:"mailman~2.1.11~8.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.8h~28.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-doc", rpm:"openssl-doc~0.9.8h~28.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Bootloader", rpm:"perl-Bootloader~0.4.81.1~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"plotutils", rpm:"plotutils~2.5~197.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pure-ftpd", rpm:"pure-ftpd~1.0.21~182.32.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-avahi", rpm:"python-avahi~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sudo", rpm:"sudo~1.6.9p17~10.36.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tsclient", rpm:"tsclient~2.0.2~2.29.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tsclient-devel", rpm:"tsclient-devel~2.0.2~2.29.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xrdp", rpm:"xrdp~0.4.1~16.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-bootloader", rpm:"yast2-bootloader~2.17.50~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-network", rpm:"yast2-network~2.17.66~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-network-devel-doc", rpm:"yast2-network-devel-doc~2.17.66~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok", rpm:"amarok~1.4.9.1~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-lang", rpm:"amarok-lang~1.4.9.1~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-libvisual", rpm:"amarok-libvisual~1.4.9.1~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-xine", rpm:"amarok-xine~1.4.9.1~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-yauap", rpm:"amarok-yauap~1.4.9.1~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"attr", rpm:"attr~2.4.43~2.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audiofile", rpm:"audiofile~0.2.6~115.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audiofile-devel", rpm:"audiofile-devel~0.2.6~115.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi", rpm:"avahi~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-howl-devel", rpm:"avahi-compat-howl-devel~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-mDNSResponder-devel", rpm:"avahi-compat-mDNSResponder-devel~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-utils", rpm:"avahi-utils~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-utils-gtk", rpm:"avahi-utils-gtk~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.4.2~39.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compat-openssl097g", rpm:"compat-openssl097g~0.9.7g~119.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libattr", rpm:"libattr~2.4.43~2.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libattr-devel", rpm:"libattr-devel~2.4.43~2.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-client3", rpm:"libavahi-client3~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-common3", rpm:"libavahi-common3~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-core5", rpm:"libavahi-core5~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-devel", rpm:"libavahi-devel~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-glib-devel", rpm:"libavahi-glib-devel~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-glib1", rpm:"libavahi-glib1~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-gobject-devel", rpm:"libavahi-gobject-devel~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-gobject0", rpm:"libavahi-gobject0~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-ui0", rpm:"libavahi-ui0~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libdns_sd", rpm:"libdns_sd~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libhowl0", rpm:"libhowl0~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libnasl", rpm:"libnasl~2.2.10~59.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl-devel", rpm:"libopenssl-devel~0.9.8g~47.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl0_9_8", rpm:"libopenssl0_9_8~0.9.8g~47.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.26~14.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.26~14.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng12-0", rpm:"libpng12-0~1.2.26~14.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nouveau-kmp-debug", rpm:"nouveau-kmp-debug~0.10.1.20081112_2.6.25.18_0.2~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nouveau-kmp-default", rpm:"nouveau-kmp-default~0.10.1.20081112_2.6.25.18_0.2~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nouveau-kmp-pae", rpm:"nouveau-kmp-pae~0.10.1.20081112_2.6.25.18_0.2~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nouveau-kmp-xen", rpm:"nouveau-kmp-xen~0.10.1.20081112_2.6.25.18_0.2~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nscd", rpm:"nscd~2.8~14.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.8g~47.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-certs", rpm:"openssl-certs~0.9.8g~47.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-doc", rpm:"openssl-doc~0.9.8g~47.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-avahi", rpm:"python-avahi~0.6.22~68.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sudo", rpm:"sudo~1.6.9p15~13.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"syslog-ng", rpm:"syslog-ng~1.6.12~76.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-driver-video-nouveau", rpm:"xorg-x11-driver-video-nouveau~0.10.1.20081112~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-driver-video-nouveau-3d", rpm:"xorg-x11-driver-video-nouveau-3d~0.10.1.20081112~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok", rpm:"amarok~1.4.7~37.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-lang", rpm:"amarok-lang~1.4.7~37.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-libvisual", rpm:"amarok-libvisual~1.4.7~37.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-xine", rpm:"amarok-xine~1.4.7~37.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-yauap", rpm:"amarok-yauap~1.4.7~37.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audiofile", rpm:"audiofile~0.2.6~77.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audiofile-devel", rpm:"audiofile-devel~0.2.6~77.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi", rpm:"avahi~0.6.20~40.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-howl", rpm:"avahi-compat-howl~0.6.20~40.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-howl-devel", rpm:"avahi-compat-howl-devel~0.6.20~40.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-mDNSResponder", rpm:"avahi-compat-mDNSResponder~0.6.20~40.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-mDNSResponder-devel", rpm:"avahi-compat-mDNSResponder-devel~0.6.20~40.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-devel", rpm:"avahi-devel~0.6.20~40.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-glib", rpm:"avahi-glib~0.6.20~40.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-python", rpm:"avahi-python~0.6.20~40.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-qt3", rpm:"avahi-qt3~0.6.20~40.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-qt4", rpm:"avahi-qt4~0.6.20~40.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.4.1.P1~12.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compat-openssl097g", rpm:"compat-openssl097g~0.9.7g~75.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.22.19~0.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.22.19~0.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.22.19~0.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.22.19~0.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.22.19~0.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.22.19~0.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xenpae", rpm:"kernel-xenpae~2.6.22.19~0.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libnasl", rpm:"libnasl~2.2.10~15.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl-devel", rpm:"libopenssl-devel~0.9.8e~45.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl0_9_8", rpm:"libopenssl0_9_8~0.9.8e~45.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng", rpm:"libpng~1.2.18~15.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.18~15.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.8e~45.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-certs", rpm:"openssl-certs~0.9.8e~45.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-doc", rpm:"openssl-doc~0.9.8e~45.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sudo", rpm:"sudo~1.6.9p2~23.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"syslog-ng", rpm:"syslog-ng~1.6.12~33.4", rls:"openSUSE10.3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
