# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SR:2009:010
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63996);
 script_cve_id("CVE-2008-2086", "CVE-2008-3104", "CVE-2008-3112", "CVE-2008-3113", "CVE-2008-3114", "CVE-2008-5339", "CVE-2008-5340", "CVE-2008-5342", "CVE-2008-5343", "CVE-2008-5344", "CVE-2008-5345", "CVE-2008-5346", "CVE-2008-5348", "CVE-2008-5350", "CVE-2008-5351", "CVE-2008-5353", "CVE-2008-5354", "CVE-2008-5356", "CVE-2008-5357", "CVE-2008-5359", "CVE-2008-5360", "CVE-2009-0146", "CVE-2009-0147", "CVE-2009-0165", "CVE-2009-0166", "CVE-2009-0368", "CVE-2009-0544", "CVE-2009-0582", "CVE-2009-0585", "CVE-2009-0590", "CVE-2009-0591", "CVE-2009-0652", "CVE-2009-0789", "CVE-2009-0799", "CVE-2009-0800", "CVE-2009-0946", "CVE-2009-1086", "CVE-2009-1179", "CVE-2009-1180", "CVE-2009-1181", "CVE-2009-1182", "CVE-2009-1183", "CVE-2009-1295", "CVE-2009-1302", "CVE-2009-1303", "CVE-2009-1304", "CVE-2009-1305", "CVE-2009-1306", "CVE-2009-1307", "CVE-2009-1308", "CVE-2009-1309", "CVE-2009-1310", "CVE-2009-1311", "CVE-2009-1312");
 script_version ("$");
 name["english"] = "SuSE Security Summary SUSE-SR:2009:010";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory SUSE-SR:2009:010.  SuSE Security Summaries are short
on detail when it comes to the names of packages affected by
a particular bug. Because of this, while this test will detect
out of date packages, it cannot tell you what bugs impact
which packages, or vice versa.

Solution:

Update all out of date packages.

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "SuSE Security Advisory SUSE-SR:2009:010";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~3.0.10~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-branding-upstream", rpm:"MozillaFirefox-branding-upstream~3.0.10~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~3.0.10~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PackageKit", rpm:"PackageKit~0.3.11~1.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PackageKit-devel", rpm:"PackageKit-devel~0.3.11~1.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PackageKit-lang", rpm:"PackageKit-lang~0.3.11~1.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport", rpm:"apport~0.114~8.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-crashdb-opensuse", rpm:"apport-crashdb-opensuse~0.114~8.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-gtk", rpm:"apport-gtk~0.114~8.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-qt", rpm:"apport-qt~0.114~8.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-retrace", rpm:"apport-retrace~0.114~8.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"banshee-1", rpm:"banshee-1~1.4.3~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"banshee-1-backend-engine-gstreamer", rpm:"banshee-1-backend-engine-gstreamer~1.4.3~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"banshee-1-backend-platform-gnome", rpm:"banshee-1-backend-platform-gnome~1.4.3~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"banshee-1-backend-platform-unix", rpm:"banshee-1-backend-platform-unix~1.4.3~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"banshee-1-devel", rpm:"banshee-1-devel~1.4.3~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"banshee-1-extensions-default", rpm:"banshee-1-extensions-default~1.4.3~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"banshee-1-lang", rpm:"banshee-1-lang~1.4.3~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"beagle", rpm:"beagle~0.3.8~46.34.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"beagle-devel", rpm:"beagle-devel~0.3.8~46.34.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"beagle-epiphany", rpm:"beagle-epiphany~0.3.8~46.34.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"beagle-evolution", rpm:"beagle-evolution~0.3.8~46.34.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"beagle-firefox", rpm:"beagle-firefox~0.3.8~46.34.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"beagle-google", rpm:"beagle-google~0.3.8~46.34.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"beagle-gui", rpm:"beagle-gui~0.3.8~46.34.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"beagle-lang", rpm:"beagle-lang~0.3.8~46.34.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"beagle-thunderbird", rpm:"beagle-thunderbird~0.3.8~46.34.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.5.0P2~18.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.5.0P2~18.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.5.0P2~18.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.5.0P2~18.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.5.0P2~18.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.5.0P2~18.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez", rpm:"bluez~4.22~6.1.10", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-alsa", rpm:"bluez-alsa~4.22~6.1.10", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-compat", rpm:"bluez-compat~4.22~6.1.10", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-cups", rpm:"bluez-cups~4.22~6.1.10", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-devel", rpm:"bluez-devel~4.22~6.1.10", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-gstreamer", rpm:"bluez-gstreamer~4.22~6.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-test", rpm:"bluez-test~4.22~6.1.10", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compat-openssl097g", rpm:"compat-openssl097g~0.9.7g~146.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd", rpm:"drbd~8.2.7~1.19.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-debug", rpm:"drbd-kmp-debug~8.2.7_2.6.27.21_0.1~1.19.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-default", rpm:"drbd-kmp-default~8.2.7_2.6.27.21_0.1~1.19.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-pae", rpm:"drbd-kmp-pae~8.2.7_2.6.27.21_0.1~1.19.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-trace", rpm:"drbd-kmp-trace~8.2.7_2.6.27.21_0.1~1.19.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-xen", rpm:"drbd-kmp-xen~8.2.7_2.6.27.21_0.1~1.19.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"enscript", rpm:"enscript~1.6.4~152.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.24.1.1~4.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~2.24.1.1~5.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-devel", rpm:"evolution-data-server-devel~2.24.1.1~5.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-doc", rpm:"evolution-data-server-doc~2.24.1.1~5.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-lang", rpm:"evolution-data-server-lang~2.24.1.1~5.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.24.1.1~4.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-lang", rpm:"evolution-lang~2.24.1.1~4.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-mono-providers", rpm:"evolution-mono-providers~0.1.1~2.18.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.24.1.1~4.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"foomatic-filters", rpm:"foomatic-filters~3.0.2~269.47.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.3.7~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.3.7~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~8.62~31.43.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.62~31.43.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.62~31.43.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.62~31.43.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-ijs-devel", rpm:"ghostscript-ijs-devel~8.62~31.43.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.62~31.43.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.62~31.43.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.62~31.43.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-packagekit", rpm:"gnome-packagekit~0.3.11~2.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-packagekit-lang", rpm:"gnome-packagekit-lang~0.3.11~2.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-session", rpm:"gnome-session~2.24.1~6.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-session-branding-upstream", rpm:"gnome-session-branding-upstream~2.24.1~6.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-session-lang", rpm:"gnome-session-lang~2.24.1~6.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2", rpm:"gtk2~2.14.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-branding-upstream", rpm:"gtk2-branding-upstream~2.14.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-devel", rpm:"gtk2-devel~2.14.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-doc", rpm:"gtk2-doc~2.14.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-lang", rpm:"gtk2-lang~2.14.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtkhtml2", rpm:"gtkhtml2~3.24.1.1~1.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtkhtml2-devel", rpm:"gtkhtml2-devel~3.24.1.1~1.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtkhtml2-lang", rpm:"gtkhtml2-lang~3.24.1.1~1.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk", rpm:"java-1_6_0-openjdk~1.4_b14~24.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-demo", rpm:"java-1_6_0-openjdk-demo~1.4_b14~24.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-devel", rpm:"java-1_6_0-openjdk-devel~1.4_b14~24.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-javadoc", rpm:"java-1_6_0-openjdk-javadoc~1.4_b14~24.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-plugin", rpm:"java-1_6_0-openjdk-plugin~1.4_b14~24.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-src", rpm:"java-1_6_0-openjdk-src~1.4_b14~24.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3", rpm:"kdegraphics3~3.5.10~1.63.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-3D", rpm:"kdegraphics3-3D~3.5.10~1.63.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-devel", rpm:"kdegraphics3-devel~3.5.10~1.63.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-extra", rpm:"kdegraphics3-extra~3.5.10~1.63.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-fax", rpm:"kdegraphics3-fax~3.5.10~1.63.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-imaging", rpm:"kdegraphics3-imaging~3.5.10~1.63.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-kamera", rpm:"kdegraphics3-kamera~3.5.10~1.63.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-pdf", rpm:"kdegraphics3-pdf~3.5.10~1.63.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-postscript", rpm:"kdegraphics3-postscript~3.5.10~1.63.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-scan", rpm:"kdegraphics3-scan~3.5.10~1.63.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-tex", rpm:"kdegraphics3-tex~3.5.10~1.63.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libbluetooth3", rpm:"libbluetooth3~4.22~6.1.10", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libfprint-devel", rpm:"libfprint-devel~0.0.6~10.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libfprint0", rpm:"libfprint0~0.0.6~10.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~31.43.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~31.43.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnomeui", rpm:"libgnomeui~2.24.0~1.36.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnomeui-devel", rpm:"libgnomeui-devel~2.24.0~1.36.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnomeui-doc", rpm:"libgnomeui-doc~2.24.0~1.36.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnomeui-lang", rpm:"libgnomeui-lang~2.24.0~1.36.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopensc2", rpm:"libopensc2~0.11.6~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl-devel", rpm:"libopenssl-devel~0.9.8h~28.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl0_9_8", rpm:"libopenssl0_9_8~0.9.8h~28.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpackagekit-glib10", rpm:"libpackagekit-glib10~0.3.11~1.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpackagekit-glib10-devel", rpm:"libpackagekit-glib10-devel~0.3.11~1.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpackagekit-qt10", rpm:"libpackagekit-qt10~0.3.11~1.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpackagekit-qt10-devel", rpm:"libpackagekit-qt10-devel~0.3.11~1.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqdialogsolver1", rpm:"libqdialogsolver1~1.2.9~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqdialogsolver1-devel", rpm:"libqdialogsolver1-devel~1.2.9~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsatsolver-devel", rpm:"libsatsolver-devel~0.13.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf", rpm:"libwmf~0.2.8.4~206.24.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf-devel", rpm:"libwmf-devel~0.2.8.4~206.24.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf-gnome", rpm:"libwmf-gnome~0.2.8.4~206.24.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxine1", rpm:"libxine1~1.1.15~23.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libzypp", rpm:"libzypp~5.29.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libzypp-devel", rpm:"libzypp-devel~5.29.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190", rpm:"mozilla-xulrunner190~1.9.0.10~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-devel", rpm:"mozilla-xulrunner190-devel~1.9.0.10~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-gnomevfs", rpm:"mozilla-xulrunner190-gnomevfs~1.9.0.10~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-translations", rpm:"mozilla-xulrunner190-translations~1.9.0.10~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp", rpm:"ntp~4.2.4p6~2.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp-doc", rpm:"ntp-doc~4.2.4p6~2.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openmotif22-libs", rpm:"openmotif22-libs~2.2.4~137.73.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opensc", rpm:"opensc~0.11.6~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opensc-devel", rpm:"opensc-devel~0.11.6~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.8h~28.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-doc", rpm:"openssl-doc~0.9.8h~28.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam_fp", rpm:"pam_fp~0.1~11.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-satsolver", rpm:"perl-satsolver~0.13.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-crypto", rpm:"python-crypto~2.0.1~28.115.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-satsolver", rpm:"python-satsolver~0.13.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-xpcom190", rpm:"python-xpcom190~1.9.0.10~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-satsolver", rpm:"ruby-satsolver~0.13.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"satsolver-tools", rpm:"satsolver-tools~0.13.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"unbound", rpm:"unbound~1.0.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"unbound-devel", rpm:"unbound-devel~1.0.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-bootloader", rpm:"yast2-bootloader~2.17.59~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-network", rpm:"yast2-network~2.17.77~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-network-devel-doc", rpm:"yast2-network-devel-doc~2.17.77~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-pkg-bindings", rpm:"yast2-pkg-bindings~2.17.38~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-qt-pkg", rpm:"yast2-qt-pkg~2.17.27~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zypper", rpm:"zypper~1.0.9~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~3.0.10~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~3.0.10~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compat-openssl097g", rpm:"compat-openssl097g~0.9.7g~119.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~2.22.1.1~11.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-devel", rpm:"evolution-data-server-devel~2.22.1.1~11.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-doc", rpm:"evolution-data-server-doc~2.22.1.1~11.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.3.5~62.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.3.5~62.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~8.62~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.62~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.62~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.62~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-ijs-devel", rpm:"ghostscript-ijs-devel~8.62~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.62~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.62~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.62~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~2.2.2~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2", rpm:"gtk2~2.12.9~37.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-branding-upstream", rpm:"gtk2-branding-upstream~2.12.9~37.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-devel", rpm:"gtk2-devel~2.12.9~37.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-doc", rpm:"gtk2-doc~2.12.9~37.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk", rpm:"java-1_6_0-openjdk~1.4_b14~24.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-demo", rpm:"java-1_6_0-openjdk-demo~1.4_b14~24.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-devel", rpm:"java-1_6_0-openjdk-devel~1.4_b14~24.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-javadoc", rpm:"java-1_6_0-openjdk-javadoc~1.4_b14~24.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-plugin", rpm:"java-1_6_0-openjdk-plugin~1.4_b14~24.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-src", rpm:"java-1_6_0-openjdk-src~1.4_b14~24.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3", rpm:"kdegraphics3~3.5.9~53.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-3D", rpm:"kdegraphics3-3D~3.5.9~53.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-devel", rpm:"kdegraphics3-devel~3.5.9~53.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-extra", rpm:"kdegraphics3-extra~3.5.9~53.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-fax", rpm:"kdegraphics3-fax~3.5.9~53.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-imaging", rpm:"kdegraphics3-imaging~3.5.9~53.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-kamera", rpm:"kdegraphics3-kamera~3.5.9~53.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-pdf", rpm:"kdegraphics3-pdf~3.5.9~53.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-postscript", rpm:"kdegraphics3-postscript~3.5.9~53.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-scan", rpm:"kdegraphics3-scan~3.5.9~53.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-tex", rpm:"kdegraphics3-tex~3.5.9~53.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~258.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~258.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-devel", rpm:"libgnutls-devel~2.2.2~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-extra-devel", rpm:"libgnutls-extra-devel~2.2.2~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-extra26", rpm:"libgnutls-extra26~2.2.2~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls26", rpm:"libgnutls26~2.2.2~17.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopensc2", rpm:"libopensc2~0.11.4~37.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl-devel", rpm:"libopenssl-devel~0.9.8g~47.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl0_9_8", rpm:"libopenssl0_9_8~0.9.8g~47.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf", rpm:"libwmf~0.2.8.4~164.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf-devel", rpm:"libwmf-devel~0.2.8.4~164.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf-gnome", rpm:"libwmf-gnome~0.2.8.4~164.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190", rpm:"mozilla-xulrunner190~1.9.0.10~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-devel", rpm:"mozilla-xulrunner190-devel~1.9.0.10~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-gnomevfs", rpm:"mozilla-xulrunner190-gnomevfs~1.9.0.10~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-translations", rpm:"mozilla-xulrunner190-translations~1.9.0.10~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp", rpm:"ntp~4.2.4p4~44.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp-doc", rpm:"ntp-doc~4.2.4p4~44.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openmotif22-libs", rpm:"openmotif22-libs~2.2.4~149.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opensc", rpm:"opensc~0.11.4~37.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opensc-devel", rpm:"opensc-devel~0.11.4~37.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.8g~47.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-certs", rpm:"openssl-certs~0.9.8g~47.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-doc", rpm:"openssl-doc~0.9.8g~47.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-crypto", rpm:"python-crypto~2.0.1~164.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-devel", rpm:"xine-devel~1.1.12~8.7", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-extra", rpm:"xine-extra~1.1.12~8.7", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.12~8.7", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compat-openssl097g", rpm:"compat-openssl097g~0.9.7g~75.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~1.12.0~5.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-devel", rpm:"evolution-data-server-devel~1.12.0~5.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-doc", rpm:"evolution-data-server-doc~1.12.0~5.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.3.5~18.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.3.5~18.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.4~3.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.4~3.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.4~3.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-ijs-devel", rpm:"ghostscript-ijs-devel~8.15.4~3.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.4~3.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.4~3.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.4~3.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3", rpm:"kdegraphics3~3.5.7~60.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-3D", rpm:"kdegraphics3-3D~3.5.7~60.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-devel", rpm:"kdegraphics3-devel~3.5.7~60.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-extra", rpm:"kdegraphics3-extra~3.5.7~60.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-fax", rpm:"kdegraphics3-fax~3.5.7~60.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-imaging", rpm:"kdegraphics3-imaging~3.5.7~60.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-kamera", rpm:"kdegraphics3-kamera~3.5.7~60.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-pdf", rpm:"kdegraphics3-pdf~3.5.7~60.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-postscript", rpm:"kdegraphics3-postscript~3.5.7~60.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-scan", rpm:"kdegraphics3-scan~3.5.7~60.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdegraphics3-tex", rpm:"kdegraphics3-tex~3.5.7~60.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~178.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~178.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopensc2", rpm:"libopensc2~0.11.3~21.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl-devel", rpm:"libopenssl-devel~0.9.8e~45.9", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl0_9_8", rpm:"libopenssl0_9_8~0.9.8e~45.9", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf", rpm:"libwmf~0.2.8.4~92.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf-devel", rpm:"libwmf-devel~0.2.8.4~92.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwmf-gnome", rpm:"libwmf-gnome~0.2.8.4~92.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openmotif22-libs", rpm:"openmotif22-libs~2.2.4~84.3", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opensc", rpm:"opensc~0.11.3~21.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opensc-devel", rpm:"opensc-devel~0.11.3~21.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.8e~45.9", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-certs", rpm:"openssl-certs~0.9.8e~45.9", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-doc", rpm:"openssl-doc~0.9.8e~45.9", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-crypto", rpm:"python-crypto~2.0.1~103.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-devel", rpm:"xine-devel~1.1.8~14.16", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-extra", rpm:"xine-extra~1.1.8~14.16", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.8~14.16", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xntp", rpm:"xntp~4.2.4p3~25.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xntp-doc", rpm:"xntp-doc~4.2.4p3~25.5", rls:"openSUSE10.3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
