!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!
!!!!   MIT License
!!!!
!!!!   ParaMonte: plain powerful parallel Monte Carlo library.
!!!!
!!!!   Copyright (C) 2012-present, The Computational Data Science Lab
!!!!
!!!!   This file is part of the ParaMonte library.
!!!!
!!!!   Permission is hereby granted, free of charge, to any person obtaining a
!!!!   copy of this software and associated documentation files (the "Software"),
!!!!   to deal in the Software without restriction, including without limitation
!!!!   the rights to use, copy, modify, merge, publish, distribute, sublicense,
!!!!   and/or sell copies of the Software, and to permit persons to whom the
!!!!   Software is furnished to do so, subject to the following conditions:
!!!!
!!!!   The above copyright notice and this permission notice shall be
!!!!   included in all copies or substantial portions of the Software.
!!!!
!!!!   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
!!!!   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
!!!!   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
!!!!   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
!!!!   DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
!!!!   OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
!!!!   OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
!!!!
!!!!   ACKNOWLEDGMENT
!!!!
!!!!   ParaMonte is an honor-ware and its currency is acknowledgment and citations.
!!!!   As per the ParaMonte library license agreement terms, if you use any parts of
!!!!   this library for any purposes, kindly acknowledge the use of ParaMonte in your
!!!!   work (education/research/industry/development/...) by citing the ParaMonte
!!!!   library as described on this page:
!!!!
!!!!       https://github.com/cdslaborg/paramonte/blob/main/ACKNOWLEDGMENT.md
!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!>  \brief This module implements the [ParaMCMC_type](@ref paramcmc_mod::paramcmc_type) class and its constructor.
!>  \author Amir Shahmoradi

module ParaMCMC_mod

    use Constants_mod, only: RK, IK
    use SpecMCMC_mod, only: SpecMCMC_type
    use ParaMonte_mod, only: ParaMonte_type, ParaMonteLogFuncMode_type, ParaMonteStatistics_type, Moment_type
    implicit none

    character(*), parameter                     :: MODULE_NAME = "@ParaMCMC_mod"

    type                                        :: ParaMCMC_Chain_type
        integer(IK)                             :: compact, verbose
    end type ParaMCMC_Chain_type

    type, extends(ParaMonteLogFuncMode_type)    :: ParaMCMC_LogFuncMode_type
        type(ParaMCMC_Chain_type)               :: Loc
    end type ParaMCMC_LogFuncMode_type

    type, extends(ParaMonteStatistics_type)     :: ParaMCMC_Statistics_type
        type(Moment_type)                       :: Chain
        type(ParaMCMC_Chain_type)               :: BurninLoc
        type(ParaMCMC_LogFuncMode_type)         :: LogFuncMode
    end type ParaMCMC_Statistics_type

    !> The `ParaMCMC_type` class.
    type, extends(ParaMonte_type)               :: ParaMCMC_type
       type(SpecMCMC_type)                      :: SpecMCMC
    contains
        procedure, pass                         :: setupParaMCMC
    end type ParaMCMC_type

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

contains

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    !> Setup the properties of the ParaMCMC parent sampler.
    !>
    !> @param[inout] PMPM : An object of class [ParaMCMC_type](@ref paramcmc_type).
    subroutine setupParaMCMC(PMPM)
#if INTEL_COMPILER_ENABLED && defined DLL_ENABLED && (OS_IS_WINDOWS || defined OS_IS_DARWIN)
        !DEC$ ATTRIBUTES DLLEXPORT :: setupParaMCMC
#endif
        use SpecMCMC_mod, only: SpecMCMC_type
        implicit none
        class(ParaMCMC_type), intent(inout)    :: PMPM
        character(*), parameter :: PROCEDURE_NAME = "@setupParaMCMC()"
        PMPM%SpecMCMC = SpecMCMC_type(nd=PMPM%nd%val,methodName=PMPM%name)
    end subroutine setupParaMCMC

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

end module ParaMCMC_mod ! LCOV_EXCL_LINE