/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.sasn1.Asn1Integer;
import org.bouncycastle.sasn1.Asn1ObjectIdentifier;
import org.bouncycastle.sasn1.BerOctetStringGenerator;
import org.bouncycastle.sasn1.BerSequenceGenerator;
import org.bouncycastle.sasn1.DerSequenceGenerator;

public class CMSCompressedDataStreamGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";

    public OutputStream open(OutputStream outputStream, String string) throws IOException {
        return this.open(outputStream, CMSObjectIdentifiers.data.getId(), string);
    }

    public OutputStream open(OutputStream outputStream, String string, String string2) throws IOException {
        BerSequenceGenerator berSequenceGenerator = new BerSequenceGenerator(outputStream);
        berSequenceGenerator.addObject(new Asn1ObjectIdentifier(CMSObjectIdentifiers.compressedData.getId()));
        BerSequenceGenerator berSequenceGenerator2 = new BerSequenceGenerator(berSequenceGenerator.getRawOutputStream(), 0, true);
        berSequenceGenerator2.addObject(new Asn1Integer(0L));
        DerSequenceGenerator derSequenceGenerator = new DerSequenceGenerator(berSequenceGenerator2.getRawOutputStream());
        derSequenceGenerator.addObject(new Asn1ObjectIdentifier(ZLIB));
        derSequenceGenerator.close();
        BerSequenceGenerator berSequenceGenerator3 = new BerSequenceGenerator(berSequenceGenerator2.getRawOutputStream());
        berSequenceGenerator3.addObject(new Asn1ObjectIdentifier(string));
        BerOctetStringGenerator berOctetStringGenerator = new BerOctetStringGenerator(berSequenceGenerator3.getRawOutputStream(), 0, true);
        return new CmsCompressedOutputStream(new DeflaterOutputStream(berOctetStringGenerator.getOctetOutputStream()), berSequenceGenerator, berSequenceGenerator2, berSequenceGenerator3);
    }

    private class CmsCompressedOutputStream
    extends OutputStream {
        private DeflaterOutputStream _out;
        private BerSequenceGenerator _sGen;
        private BerSequenceGenerator _cGen;
        private BerSequenceGenerator _eiGen;

        CmsCompressedOutputStream(DeflaterOutputStream deflaterOutputStream, BerSequenceGenerator berSequenceGenerator, BerSequenceGenerator berSequenceGenerator2, BerSequenceGenerator berSequenceGenerator3) {
            this._out = deflaterOutputStream;
            this._sGen = berSequenceGenerator;
            this._cGen = berSequenceGenerator2;
            this._eiGen = berSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this._out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            this._cGen.close();
            this._sGen.close();
        }
    }
}

