/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;

public class CMSEnvelopedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private AlgorithmIdentifier encAlg;
    private ASN1Set unprotectedAttributes;
    private AlgorithmIdentifier _encAlg;

    private static ContentInfo readContentInfo(InputStream inputStream) throws CMSException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
            return ContentInfo.getInstance((Object)aSN1InputStream.readObject());
        }
        catch (IOException iOException) {
            throw new CMSException("IOException reading content.", iOException);
        }
    }

    public CMSEnvelopedData(byte[] byArray) throws CMSException {
        this(CMSEnvelopedData.readContentInfo(new ByteArrayInputStream(byArray)));
    }

    public CMSEnvelopedData(InputStream inputStream) throws CMSException {
        this(CMSEnvelopedData.readContentInfo(inputStream));
    }

    public CMSEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        EnvelopedData envelopedData = EnvelopedData.getInstance((Object)contentInfo.getContent());
        EncryptedContentInfo encryptedContentInfo = envelopedData.getEncryptedContentInfo();
        this._encAlg = encryptedContentInfo.getContentEncryptionAlgorithm();
        ASN1Set aSN1Set = envelopedData.getRecipientInfos();
        ArrayList<RecipientInformation> arrayList = new ArrayList<RecipientInformation>();
        for (int i = 0; i != aSN1Set.size(); ++i) {
            RecipientInfo recipientInfo = RecipientInfo.getInstance((Object)aSN1Set.getObjectAt(i));
            if (recipientInfo.getInfo() instanceof KeyTransRecipientInfo) {
                arrayList.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)recipientInfo.getInfo(), this._encAlg, (InputStream)new ByteArrayInputStream(encryptedContentInfo.getEncryptedContent().getOctets())));
                continue;
            }
            if (!(recipientInfo.getInfo() instanceof KEKRecipientInfo)) continue;
            arrayList.add(new KEKRecipientInformation((KEKRecipientInfo)recipientInfo.getInfo(), this._encAlg, (InputStream)new ByteArrayInputStream(encryptedContentInfo.getEncryptedContent().getOctets())));
        }
        this.encAlg = envelopedData.getEncryptedContentInfo().getContentEncryptionAlgorithm();
        this.recipientInfoStore = new RecipientInformationStore(arrayList);
        this.unprotectedAttributes = envelopedData.getUnprotectedAttrs();
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)dEREncodable);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public String getEncryptionAlgOID() {
        return this.encAlg.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encAlg.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(String string) throws CMSException, NoSuchProviderException {
        try {
            byte[] byArray = this.encodeObj(this.encAlg.getParameters());
            if (byArray == null) {
                return null;
            }
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.getEncryptionAlgOID(), string);
            algorithmParameters.init(byArray, "ASN.1");
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find parameters for algorithm", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't find parse parameters", iOException);
        }
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public AttributeTable getUnprotectedAttributes() {
        if (this.unprotectedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.unprotectedAttributes);
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
        aSN1OutputStream.writeObject((Object)this.contentInfo);
        return byteArrayOutputStream.toByteArray();
    }
}

