/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace peekabot {

/**
\mainpage User manual

\section manual_toc Table of contents
<ul style="list-style-type: none;">
  <li>\subpage manual_installation</li>
  <li>\subpage manual_tutorials
    <ul style="list-style-type: none;">
      <li>\ref manual_the_basics</li>
    </ul>
  </li>
  <li>\subpage manual_primitives
    <ul style="list-style-type: none;">
      <li>\ref manual_primitives_basic</li>
      <li>\ref manual_primitives_clouds</li>
      <li>\ref manual_primitives_tri_mesh</li>
      <li>\ref manual_primitives_grid</li>
      <li>\ref manual_primitives_camera</li>
      <li>\ref manual_primitives_model</li>
      <li>\ref manual_primitives_joints</li>
      <li>\ref manual_primitives_label</li>
    </ul>
  </li>
  <li>\subpage manual_scenedef
    <ul style="list-style-type: none;">
      <li>\ref manual_scenedef_overview</li>
      <li>\ref manual_scenedef_reference
        <ul style="list-style-type: none;">
          <li>\ref manual_scenedef_layer_and_color</li>
          <li>\ref manual_scenedef_external</li>
          <li>\ref manual_scenedef_include</li>
          <li>\ref manual_scenedef_common
          <ul style="list-style-type: none;">
            <li>\ref manual_scenedef_transform</li>
          </ul>
          </li>
          <li>\ref manual_scenedef_scale</li>
          <li>\ref manual_scenedef_line_based</li>
          <li>\ref manual_scenedef_camera</li>
          <li>\ref manual_scenedef_group</li>
          <li>\ref manual_scenedef_primitives1</li>
          <li>\ref manual_scenedef_primitives2</li>
          <li>\ref manual_scenedef_tri_mesh</li>
          <li>\ref manual_scenedef_model</li>
          <li>\ref manual_scenedef_grid</li>
          <li>\ref manual_scenedef_label</li>
          <li>\ref manual_scenedef_joints
          <ul style="list-style-type: none;">
            <li>\ref manual_scenedef_hinge</li>
            <li>\ref manual_scenedef_slider</li>
          </ul>
          </li>
        </ul>
      </li>
      <li>\ref manual_scenedef_advanced
        <ul style="list-style-type: none;">
          <li>\ref manual_scenedef_advanced_inject</li>
          <li>\ref manual_scenedef_advanced_external</li>
        </ul>
      </li>
    </ul>
  </li>
  <li>\subpage manual_model_conversion</li>
  <li>\subpage manual_configuration</li>
</ul>

*/


}
