/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace peekabot {

/**

\page manual_model_conversion Model conversion


\section manual_primitives_model_supported_formats Supported model formats

While we hope to support more formats in the future, peekabot can currently 
only load models in its own binary format - \em pbmf.

The reason for using our homebrew custom binary format is performance. Parsing 
text formats is extremely slow in comparison. Furthermore, it allows us do some
calculations offline during the conversion stage, rather than doing it every
time the file is loaded.

At the moment, only PNG files are supported as texture.

\section manual_primitives_model_conversion Model conversion

peekabot ships with a conversion utility called \c obj2pbmf that converts 
models in Wavefront OBJ format to pbmf. OBJ is de facto standard and your 
favorite tool can most likely export it.

Performing the conversion is very simple - you can see how the conversion
utility is invoked below:

\par
\verbatim$ obj2pbmf [--override-normals] [--texture <filename>] <input.obj> <output.pbmf>\endverbatim

Since the OBJ file format doesn't include support for specifying which 
texture file to use you must specify it explicitly with the \c --texture
argument in case your model has a texture.

*/

}
