/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BO_SLAM_HH_INCLUDED
#define BO_SLAM_HH_INCLUDED


#include <map>
#include <vector>
#include <peekabot.hh>

#include "BearingOnlySLAM2D.hh"


class BoSLAM
{
public:
    BoSLAM(
        double sigma1 = 0.02,
        double sigma2 = 0.025,
        double sigma3 = 0.05);

    void update(
        double ds, double dtheta,
        std::vector<BearingOnlySLAM2D::Observation> &obs);

private:
    void update_visualization(
        const std::vector<BearingOnlySLAM2D::Observation> &obs,
        const ublas::matrix<double> &pose_cov);

    static void update_cov2d(
        peekabot::CircleProxy &p,
        const ublas::matrix<double> &C);

private:
    BearingOnlySLAM2D m_filter;

    double m_curr_x, m_curr_y, m_curr_theta;
    double m_curr_odom_x, m_curr_odom_y, m_curr_odom_theta;

    std::map<std::size_t, peekabot::CircleProxy> m_feats;

    // Visualization stuff
    peekabot::PeekabotClient m_client;

    peekabot::GroupProxy m_grp, m_grp_est, m_grp_odom;
    peekabot::PolylineProxy m_path_est, m_path_odom;
    peekabot::CircleProxy m_pose_cov;
    peekabot::LineCloudProxy m_obs;
    peekabot::GroupProxy m_robot;
};


#endif // BO_SLAM_HH_INCLUDED
