/*
 * Copyright Staffan Gimåker 2009-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

/*
 * This is a bare bones template for peekabot clients, that includes everything
 * that we generally recommend including - use it as a base for your own
 * clients.
 */

#include <cmath> // needed for sinf
#include <peekabot.hh>


int main(int argc, char *argv[])
{
    // You always need a peekabot client, it handles the connection
    // to the server and takes care of "low level" stuff
    peekabot::PeekabotClient client;
    client.connect("localhost");

    // Tip: Putting all your stuff under a group makes it to remove and/or
    // overwrite when re-starting the client.
    peekabot::GroupProxy grp;
    grp.add(client, "grp", peekabot::REPLACE_ON_CONFLICT);

    peekabot::SphereProxy prxy;
    prxy.add(grp, "sphere");

    float t = 0;
    while( client.is_connected() )
    {
        // Note: You generally want to use bundling, and some kind of
        // synchronization mechanism.
        peekabot::Status s = client.noop().status();
        client.begin_bundle();

        // ... visualization stuff here ...
        prxy.set_position(0, 0, sinf(t += 0.05f));

        client.end_bundle();
        s.wait_until_completed();
    }

    return 0;
}
