/*
 * Copyright Staffan Gimåker 2006-2008.
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef __PEEKABOT_BYTESEX_HH
#define __PEEKABOT_BYTESEX_HH

/**
 * \file
 * \brief Contains functionality for getting the system's endianess and some
 * auxillary functions for handling endian-dependent data.
 */

#include <boost/detail/endian.hpp>


#define PEEKABOT_LITTLE_ENDIAN 1234
#define PEEKABOT_BIG_ENDIAN 4321

#if defined(BOOST_LITTLE_ENDIAN)
#  define PEEKABOT_BYTE_ORDER PEEKABOT_LITTLE_ENDIAN
#elif defined(BOOST_BIG_ENDIAN)
#  define PEEKABOT_BYTE_ORDER PEEKABOT_BIG_ENDIAN
#else
#  error "Unsupported platform endianess (Middle/PDP-endian)"
#endif


#include "Types.hh"
#include <cstdlib>

namespace peekabot
{   
    /**
     * \brief: Converts indata from LE or BE to BE or LE respectively.
     *
     * \param p The array of data to be converted.
     * \param element_count The number of elements in the \c p array.
     * \return A pointer to the modified array.
     */
    template<class T>
    inline T *switch_byte_order(T *p, const size_t element_count)
    {
        int8_t *pb = reinterpret_cast<int8_t *>(p);
        for( size_t elem = 0; elem < element_count; ++elem )
        {
            for( size_t i = 0; i < sizeof(T); i+=2 )
            {
                int8_t tmp = pb[i];
                pb[i] = pb[sizeof(T) - i - 1];
                pb[sizeof(T) - i - 1] = tmp;
            }
            pb += sizeof(T);
        }
        return p;
    }

}


#endif // __PEEKABOT_BYTESEX_HH
