/*
 * Copyright Staffan Gimåker 2006-2010.
 * Copyright Anders Boberg 2006-2007.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_CYLINDER_OBJECT_HH_INCLUDED
#define PEEKABOT_CYLINDER_OBJECT_HH_INCLUDED


#include "SceneObject.hh"
#include "ScalableObject.hh"
#include "HandlerInformer.hh"


namespace peekabot
{
    /**
     * \internal
     */
    class CylinderObject : public SceneObject, public ScalableObject
    {
    public:
        CylinderObject();

        CylinderObject(ScopedHandler *handler);

        virtual void accept(ObjectVisitor* visitor) throw();

        virtual ObjectType get_object_type() const;

    protected:
        virtual PropMap &get_prop_adapters();

    private:
        /** \brief Element start handler for XML parsing.
         */
        static void start_handler(
            const std::string & name,
            XMLHandler::AttributeMap &attributes,
            ScopedHandler *handler) throw();

    private:
        static HandlerInformer ms_handler_informer;
    };
}


#endif // PEEKABOT_CYLINDER_OBJECT_HH_INCLUDED
