/*
 * Copyright Staffan Gimåker 2007, 2009-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <boost/format.hpp>
#include <boost/filesystem/operations.hpp>

#include "FsToolbox.hh"
#include "MessageHub.hh"
#include "UploadCache.hh"


using namespace peekabot;


fs::path fs::get_home_path() throw()
{
    std::string dir;

    if( getenv("HOME") ) // For unices
        dir = getenv("HOME");
    else if( getenv("USERPOFILE") ) // For Windows ...
        dir = getenv("USERPOFILE");
    else if( getenv("HOMEDRIVE") && getenv("HOMEPATH") )
        dir = (boost::format("%1%%2%") %
               getenv("HOMEDRIVE") % getenv("HOMEPATH")).str();
    else
    {
        dir = ".";
        TheMessageHub::instance().publish(
            WARNING_MESSAGE,
            "Failed to determine user home directory, using ./");
    }

    return fs::make_path(dir);
}


fs::path fs::get_resource_path() throw()
{
    if( getenv("APPDATA") ) // For Windows
        return fs::make_path(getenv("APPDATA")) / fs::make_path(".peekabot");
    else
        return get_home_path() / make_path(".peekabot");
}


fs::path fs::get_pkgdata_path() throw()
{
    return fs::make_path(PKGDATADIR);
}


fs::path fs::get_temp_path() throw()
{
    std::string dir;

    if( boost::filesystem::exists("/tmp/") &&
        boost::filesystem::is_directory("/tmp/") )
        dir = "/tmp/";
    else if( getenv("TEMP") &&
             boost::filesystem::exists(getenv("TEMP")) &&
             boost::filesystem::is_directory(getenv("TEMP")) ) // For windows
        dir = getenv("TEMP");
    else
    {
        dir = ".";
        TheMessageHub::instance().publish(
            WARNING_MESSAGE,
            "Failed to determine temp directory, using ./");
    }

    return fs::path(dir);
}


void fs::create_dir_if_inexistant(const fs::path &path)
{
    if( !boost::filesystem::exists(path) )
    {
        boost::filesystem::create_directory(path);

        TheMessageHub::instance().publish(
            INFO_MESSAGE,
            "Directory " + path.string() + " created");
    }
    else if( !boost::filesystem::is_directory(path) )
    {
        TheMessageHub::instance().publish(
            WARNING_MESSAGE,
            "create_dir_if_inexistant: Path " + path.string() + 
            " is not a directory");
    }
}
