/*
 * Copyright Staffan Gimåker 2007, 2009.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_FS_FS_TOOLBOX_HH_INCLUDED
#define PEEKABOT_FS_FS_TOOLBOX_HH_INCLUDED


#include <string>
#include <list>
#include <boost/filesystem/path.hpp>


namespace peekabot
{
    namespace fs
    {
        typedef boost::filesystem::path path;

        path get_resource_path() throw();

        path get_home_path() throw();

        path get_pkgdata_path() throw();

        path get_temp_path() throw();

        void create_dir_if_inexistant(const path &path);

        inline path make_path(const std::string &_path) throw()
        {
            return path(_path, boost::filesystem::native);
        }
    }
}


#endif // PEEKABOT_FS_FS_TOOLBOX_HH_INCLUDED
