/*
 * Copyright Staffan Gimåker 2006-2007, 2009-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GROUP_OBJECT_HH_INCLUDED
#define PEEKABOT_GROUP_OBJECT_HH_INCLUDED


#include "SceneObject.hh"
#include "HandlerInformer.hh"


namespace peekabot
{
    class ObjectVisitor;

    /**
     * \internal
     *
     * \brief Class representing a group of other objects.
     *
     * \sa \c SceneObject
     */
    class GroupObject : public SceneObject
    {
    public:
        GroupObject() throw();
        GroupObject(ScopedHandler* handler) throw();

        virtual void accept(ObjectVisitor* visitor) throw();

        virtual ObjectType get_object_type() const;

    private:
        /** \brief Element start handler for XML parsing.
         */
        static void start_handler(
            const std::string & name,
            XMLHandler::AttributeMap &attributes,
            ScopedHandler *handler) throw();

    private:
        static HandlerInformer ms_handler_informer;
    };
}


#endif // PEEKABOT_GROUP_OBJECT_HH_INCLUDED
