/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PEEKABOT_HANDLER_INFORMER_HH
#define __PEEKABOT_HANDLER_INFORMER_HH


#include <map>
#include <string>
#include <boost/function.hpp>


namespace peekabot
{

    class ScopedHandler;

    class HandlerInformer
    {
    public:

        // Note - the HandlerInformer constructor is defined in SceneFileLoader.cc
        // in order to reduce include file dependencies.
        
        /** \brief Registers a tag start handler with the \c SceneFileLoader
         * class.
         */
        HandlerInformer(
            const std::string &name,
            boost::function<void (const std::string &,
                                  std::map<std::string, std::string>&,
                                  ScopedHandler*)> handler);

    };
}


#endif // __PEEKABOT_HANDLER_INFORMER_HH
