/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <set>
#include <Eigen/Core>
#include <Eigen/Geometry>
#include <boost/scoped_ptr.hpp>

#include "Init.hh"
#include "Types.hh"
#include "Sockets.hh"
#include "serialization/SerializableFactory.hh"
#include "serialization/Any.hh"
#include "serialization/Containers.hh"
#include "serialization/Types.hh"
#include "serialization/Eigen.hh"
#include "ActionRegistry.hh"


using namespace peekabot;


namespace
{
    /**
     * \brief Keeps track of how many times init() was called.
     *
     * Calling init() and cleanup() increments and decrements it by one
     * respectively. When \c init_count goes from and to zero actual init
     * and clean up is performed.
     */
    int init_count = 0;

    void register_any_types()
    {
        register_any_type<boost::uint8_t>(50003);
        register_any_type<boost::int8_t>(50004);
        register_any_type<boost::uint16_t>(50005);
        register_any_type<boost::int16_t>(50006);
        register_any_type<boost::uint32_t>(50007);
        register_any_type<boost::int32_t>(50008);
        register_any_type<boost::uint64_t>(50009);
        register_any_type<boost::int64_t>(50010);
        register_any_type<float>(50011);
        register_any_type<double>(50012);
        register_any_type<bool>(50013);
        register_any_type<std::string>(50014);
        register_any_type<std::vector<std::string> >(50015);
        register_any_type<RGBColor>(50016);
        register_any_type<Opacity>(50017);
        register_any_type<Vector3>(50018);
        register_any_type<Transformation>(50019);
        register_any_type<Eigen::Vector3f>(50020);
        register_any_type<Eigen::Transform3f>(50021);
        register_any_type<LineStyle>(50022);
        register_any_type<TextAlignment>(50023);
        register_any_type<GridType>(50024);
        register_any_type<VertexOverflowPolicy>(50025);
    }
}


void peekabot::init()
{
    if( init_count == 0 )
    {
        register_actions();
        register_any_types();
        sockets::sockets_init();
    }

    ++init_count;
}


void peekabot::cleanup()
{
    if( init_count > 0 )
    {
        --init_count;

        if( init_count == 0 )
        {
            sockets::sockets_cleanup();
            TheSerializableFactory::instance().deregister_all();
        }
    }
}
