/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <boost/date_time/posix_time/posix_time.hpp>

#include "Log.hh"


using namespace peekabot;



Log::Log(const std::string &filename, const MessageFormatter &formatter) 
    throw(std::runtime_error)
    : m_ofs(filename.c_str()),
      m_formatter(formatter)
{
    if( !m_ofs.is_open() )
        throw std::runtime_error("Could not open log file, " + filename);
}


void Log::handle_message(const Message &message) throw()
{
    m_ofs << m_formatter.format(message);
    m_ofs.flush();
}
