/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PEEKABOT_LOG_HH
#define __PEEKABOT_LOG_HH


#include <string>
#include <fstream>
#include <stdexcept>

#include "Subscriber.hh"
#include "MessageFormatter.hh"


namespace peekabot
{

    /**
     * \internal
     *
     * \brief A class for logging messages to file.
     */
    class Log : public Subscriber
    {
        /**
         * \brief The output file stream.
         */
        std::ofstream m_ofs;

        /**
         * \brief The formatter used to format the log messages.
         */
        const MessageFormatter &m_formatter;

    public:
        /**
         * \brief Create a new log.
         *
         * If the file of the given filename already exists, it will be 
         * overwritten.
         *
         * \param filename The log filename.
         * \param formatter The formatter to use for message formatting.
         *
         * \exception std::runtime_error Cast if \c filename cannot be opened 
         *                               for writing.
         */
        Log(const std::string &filename, const MessageFormatter &formatter) 
            throw(std::runtime_error);

        virtual ~Log() throw() {}

        /**
         * \brief Writes the message to file immediately (i.e. after writing it,
         * it flushes the buffers).
         */
        virtual void handle_message(const Message &message) throw();
    };

}


#endif // __PEEKABOT_LOG_HH
