/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



#include "Message.hh"


using namespace peekabot;



Message::Message(MessageType type, const std::string &message) throw()
    : m_message(message),
      m_type(type),
      m_has_source(false),
      m_source(NOBODY_SOURCE_ID),
      m_timestamp(boost::posix_time::microsec_clock::local_time())
{
}


Message::Message(
    MessageType type, SourceID source, const std::string &message) throw()
    : m_message(message),
      m_type(type),
      m_has_source(true),
      m_source(source),
      m_timestamp(boost::posix_time::microsec_clock::local_time())
{
}


const std::string &Message::get_message() const throw()
{
    return m_message;
}


MessageType Message::get_type() const throw()
{
    return m_type;
}


bool Message::has_source() const throw()
{
    return m_has_source;
}

SourceID Message::get_source() const throw()
{
    return m_source;
}

        // time the message was published
boost::posix_time::ptime Message::get_timestamp() const throw()
{
    return m_timestamp;
}
