/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PEEKABOT_MESSAGE_FORMATTER_HH
#define __PEEKABOT_MESSAGE_FORMATTER_HH


#include <string>

#include "Message.hh"


namespace peekabot
{

    /**
     * \internal
     *
     * \brief An interface providing methods for formatting messages, i.e. 
     * turning a \c Message object into a string.
     *
     * \e Rationale: Separating formatting from the target of the messages
     * (typically a log file or a console) allows greater flexibility, potential
     * for reuse and new formatting schemes and output methods to be added 
     * easily.
     */
    class MessageFormatter
    {
    public:
        virtual ~MessageFormatter() {}

        /**
         * \brief Return a formatted string-version of the specified message.
         *
         * \param m The message which to format.
         */
        virtual std::string format(const Message &m) const = 0;
    };

}


#endif // __PEEKABOT_MESSAGE_FORMATTER_HH
