/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_OBJECT_TYPES_HH_INCLUDED
#define PEEKABOT_OBJECT_TYPES_HH_INCLUDED


#include "Types.hh"


#ifdef OBJ_TYPE_ID
#  error "OBJ_TYPE_ID already defined"
#else
#  define OBJ_TYPE_ID(no, classes) (classes | (no+1))
#endif

#ifdef OBJ_CLASS_ID
#  error "OBJ_CLASS_ID already defined"
#else
#  define OBJ_CLASS_ID(class_) (1<<(16+class_))
#endif


namespace peekabot
{
    enum
    {
        SCALABLE_CLASS = OBJ_CLASS_ID(0),
        VERTEX_BASED_CLASS = OBJ_CLASS_ID(1),
        LINE_BASED_CLASS = OBJ_CLASS_ID(2),
        JOINT_CLASS = OBJ_CLASS_ID(3),

        SPHERE_OBJECT = OBJ_TYPE_ID(0, SCALABLE_CLASS),
        CUBE_OBJECT = OBJ_TYPE_ID(1, SCALABLE_CLASS),
        CYLINDER_OBJECT = OBJ_TYPE_ID(2, SCALABLE_CLASS),
        CIRCLE_OBJECT = OBJ_TYPE_ID(3, SCALABLE_CLASS | LINE_BASED_CLASS),
        POLYGON_OBJECT = OBJ_TYPE_ID(4, SCALABLE_CLASS | VERTEX_BASED_CLASS),
        LINE_CLOUD_OBJECT = OBJ_TYPE_ID(5, SCALABLE_CLASS | VERTEX_BASED_CLASS | LINE_BASED_CLASS),
        POINT_CLOUD_OBJECT = OBJ_TYPE_ID(6, SCALABLE_CLASS | VERTEX_BASED_CLASS),
        GRID_OBJECT = OBJ_TYPE_ID(7, SCALABLE_CLASS | LINE_BASED_CLASS),
        LABEL_OBJECT = OBJ_TYPE_ID(8, SCALABLE_CLASS),
        CAMERA_OBJECT = OBJ_TYPE_ID(9, 0),
        OG2D_OBJECT = OBJ_TYPE_ID(10, SCALABLE_CLASS),
        OG3D_OBJECT = OBJ_TYPE_ID(11, SCALABLE_CLASS),
        TRI_MESH_OBJECT = OBJ_TYPE_ID(12, SCALABLE_CLASS | VERTEX_BASED_CLASS),
        GROUP_OBJECT = OBJ_TYPE_ID(13, 0),
        SLIDER_OBJECT = OBJ_TYPE_ID(14, JOINT_CLASS),
        HINGE_OBJECT = OBJ_TYPE_ID(15, JOINT_CLASS),
        POLYLINE_OBJECT = OBJ_TYPE_ID(16, SCALABLE_CLASS | VERTEX_BASED_CLASS | LINE_BASED_CLASS),
        MODEL_OBJECT = OBJ_TYPE_ID(17, SCALABLE_CLASS)
    };
}


#undef OBJ_CLASS_ID
#undef OBJ_TYPE_ID


#endif // PEEKABOT_OBJECT_TYPES_HH_INCLUDED
