/*
 * Copyright Anders Boberg 2006.
 * Copyright Staffan Gimåker 2006-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_OBJECT_VISITOR_HH_INCLUDED
#define PEEKABOT_OBJECT_VISITOR_HH_INCLUDED


namespace peekabot
{
    class SceneObject;
    class CameraObject;
    class ModelObject;
    class SphereObject;
    class GroupObject;
    class CubeObject;
    class PolygonObject;
    class CylinderObject;
    class CircleObject;
    class Polyline;
    class Hinge;
    class Slider;
    class GridObject;
    class PointCloud;
    class LineCloud;
    class OccupancyGrid2D;
    class OccupancyGrid3D;
    class Label;
    class TriMesh;


    /**
     * \internal
     *
     * \brief Interface for visitors of SceneObject derived classes.
     *
     * Each class that inherits from SceneObject should implement its own 
     * accept() method, the sole purpose of which is to call the visit() method 
     * of a visitor object implementing this interface and provide its \c this 
     * pointer as the parameter. This is a very convenient way of performing 
     * implicit typecasts.
     */
    class ObjectVisitor
    {
    public:
        virtual ~ObjectVisitor() {}

        virtual void visit(CameraObject *obj) = 0;

        virtual void visit(ModelObject *obj) = 0;

        virtual void visit(SphereObject *obj) = 0;

        virtual void visit(GroupObject *obj) = 0;

        virtual void visit(CubeObject *obj) = 0;

        virtual void visit(PolygonObject *obj) = 0;

        virtual void visit(CylinderObject *obj) = 0;

        virtual void visit(CircleObject *obj) = 0;

        virtual void visit(Polyline *obj) = 0;

        virtual void visit(Hinge *obj) = 0;

        virtual void visit(Slider *obj) = 0;

        virtual void visit(GridObject *obj) = 0;

        virtual void visit(PointCloud *obj) = 0;

        virtual void visit(LineCloud *obj) = 0;

        virtual void visit(OccupancyGrid2D *obj) = 0;

        virtual void visit(OccupancyGrid3D *obj) = 0;

        virtual void visit(Label *obj) = 0;

        virtual void visit(TriMesh *obj) = 0;
    };
}


#endif // PEEKABOT_OBJECT_VISITOR_HH_INCLUDED
