/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_PATH_HH_INCLUDED
#define PEEKABOT_PATH_HH_INCLUDED


#include <list>
#include <string>
#include <boost/shared_ptr.hpp>
#include <boost/filesystem/path.hpp>


namespace peekabot
{
    class UploadCache;

    /**
     * \internal
     *
     * \brief A path type with support for client-uploaded files and search
     * directories.
     */
    class Path
    {
    public:
        Path();

        explicit Path(const std::string &path);

        Path(
            const std::string &path,
            const boost::shared_ptr<UploadCache> &upload_cache,
            const std::list<boost::filesystem::path> &search_dirs);

        Path(const Path &other);

        Path &operator=(const Path &other);

        boost::filesystem::path expand(
            const std::string &path,
            const std::list<boost::filesystem::path> &extra_dirs) const;

        boost::filesystem::path get_expanded_path() const;

        void set_path(const std::string &path);

        const std::string &get_path() const;

        void set_upload_cache(const boost::shared_ptr<UploadCache> &upload_cache);

        boost::shared_ptr<const UploadCache> get_upload_cache() const;

        void append_search_dir(const boost::filesystem::path &dir);

        void prepend_search_dir(const boost::filesystem::path &dir);

        void set_search_dirs(
            const std::list<boost::filesystem::path> &search_dirs);

    private:
        std::string m_path;

        boost::shared_ptr<const UploadCache> m_upload_cache;

        std::list<boost::filesystem::path> m_search_dirs;
    };
}


#endif // PEEKABOT_PATH_HH_INCLUDED
