/*
 * Copyright Staffan Gimåker 2009
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_PBAR_READER_HH_INCLUDED
#define PEEKABOT_PBAR_READER_HH_INCLUDED


#include <fstream>
#include <boost/shared_ptr.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>

#include "Types.hh"


namespace peekabot
{
    class Action;

    /**
     * \internal
     *
     * This class is NOT thread-safe.
     */
    class PbarReader
    {
    public:
        PbarReader(const std::string &filename);

        void get_peekabot_version(
            uint8_t &major,
            uint8_t &minor,
            uint8_t &revision,
            uint8_t &rc) const;

        uint32_t get_format_version() const;

        bool is_multi_client_recording() const;

        const boost::posix_time::time_duration &get_next_action_time() const;

        boost::shared_ptr<Action> get_next_action();

        bool eof() const;

        const boost::posix_time::time_duration &duration() const;

        size_t action_count() const;

    private:
        void read_preamble();

        void read_timestamp();

        void read_epilogue();

    private:
        std::ifstream m_ifs;

        bool m_file_is_be;
        uint32_t m_pbar_version;
        uint32_t m_peekabot_version;
        bool m_multi_client_recording;
        boost::posix_time::time_duration m_duration;
        uint32_t m_action_count;

        boost::posix_time::time_duration m_next_t;

        size_t m_file_size;
    };
}


#endif // PEEKABOT_PBAR_READER_HH_INCLUDED
