/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_PROP_KEYS_HH_INCLUDED
#define PEEKABOT_PROP_KEYS_HH_INCLUDED


namespace peekabot
{
    /*
     * Predefined prop keys used for property adapters.
     *
     * All values used should be less than 10000, as those are reserved for use
     * by property adapters.
     */
    enum
    {
        // Common
        NAME_PROP = 1,
        LAYER_PROP = 5,
        COLOR_PROP = 10,
        HIDDEN_PROP = 15,
        VISIBILITY_PROP = 20,
        OPACITY_PROP = 25,
        MTOW_PROP = 30,
        SCALE_PROP = 35,
        POS_PROP = 40,
        // Camera
        CAMERA_ORTHO_PROP = 100,
        CAMERA_FOV_PROP = 105,
        CAMERA_ZOOM_DISTANCE_PROP = 110,
        CAMERA_NEAR_PROP = 115,
        CAMERA_FAR_PROP = 120,
        // Grid
        GRID_TYPE_PROP = 200,
        GRID_SEGMENTS_PROP = 205,
        GRID_CENTRAL_ANGLE_PROP = 210,
        // Label
        LABEL_TEXT_PROP = 300,
        LABEL_ALIGNMENT_PROP = 305,
        // Line-based
        LINE_STYLE_PROP = 400,
        LINE_STIPPLE_FACTOR_PROP = 405,
        LINE_WIDTH_PROP = 410,
        // Vertex-based
        MAX_VERTICES_PROP = 500,
        VERTEX_OVERFLOW_POLICY_PROP = 505,
        // Joint
        JOINT_VALUE_PROP = 600,
        JOINT_MIN_PROP = 605,
        JOINT_MAX_PROP = 610,
        JOINT_OFFSET_PROP = 615,
        // OccupancyGrid2D
        OG2D_CELL_SIZE_PROP = 2000,
        OG2D_UNOCCUPIED_COLOR_PROP = 2005,
        OG2D_OCCUPIED_COLOR_PROP = 2010,
        // Hinge
        HINGE_AXIS_PROP = 2100,
        HINGE_PIVOT_PROP = 2105,
        // Slider
        SLIDER_AXIS_PROP = 2200,
        // OccupancyGrid3D
        OG3D_CELL_XY_SIZE_PROP = 2300,
        OG3D_CELL_Z_SIZE_PROP = 2305,
        OG3D_COLOR_MAPPING_ENABLED_PROP = 2310,
        OG3D_COLOR_MAPPING_Z_MIN_PROP = 2315,
        OG3D_COLOR_MAPPING_Z_MAX_PROP = 2320
    };
}


#endif // PEEKABOT_PROP_KEYS_HH_INCLUDED
