/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_PROTOCOL_HH_INCLUDED
#define PEEKABOT_PROTOCOL_HH_INCLUDED


#include "Types.hh"


namespace peekabot
{
    namespace protocol
    {
        extern const uint32_t PROTOCOL_VERSION;

        extern const uint32_t UNIQUE_ID;

        extern const unsigned int AUTHENTICATION_TIMEOUT;

        enum AuthenticationResult
        {
            AUTH_SUCCEEDED = 0,
            AUTH_NO_MORE_CONNECTIONS = 1,
            AUTH_INCOMPAT_PEEKABOT_VERSION = 2,
            AUTH_INCOMPAT_PROTOCOL_VERSION = 3,
            AUTH_CLIENT_RECEIVED_UNEXPECTED_DATA = 4,
            AUTH_SERVER_RECEIVED_UNEXPECTED_DATA = 5,
            //
            AUTH_UNEXPECTED_DATA_RECEIVED = 6,
            AUTH_AUTHENTICATION_TIMED_OUT = 7,
            AUTH_CONNECTION_CLOSED_BY_PEER = 8
        };


        /*enum AuthenticationStatus
        {
            AUTHENTICATION_SUCCESSFUL = 0,
            AUTHENTICATION_FAILED = 1,
            NO_MORE_CONNECTIONS = 2,
            UNSUPPORTED_VERSION = 3,
            UNSUPPORTED_PROTOCOL = 4
        };*/
    }
}


#endif // PEEKABOT_PROTOCOL_HH_INCLUDED
