/*
 * Copyright Anders Boberg 2007.
 * Copyright Staffan Gimåker 2007-2008, 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_SCENE_FILE_LOADER_HH_INCLUDED
#define PEEKABOT_SCENE_FILE_LOADER_HH_INCLUDED


#include "ScopedHandler.hh"
#include "HandlerInformer.hh"
#include "Types.hh"

#include <string>
#include <vector>
#include <set>
#include <boost/filesystem/path.hpp>


namespace peekabot
{
    class Config;
    class ScopedHandler;
    class SceneObject;
    class Path;

    class SceneFileLoader
    {
    public:
        static std::vector<SceneObject *> load_scene(
            const Config &config, const Path &path);

        static bool register_creator(
            const std::string &name,
            ScopedHandler::ElementStartFunctor);

        static const ScopedHandler::StartFunctorMap & get_start_handlers();

    private:
        static void start_of_document(
            ScopedHandler *handler, const std::string &top_level_tag);

        static void end_of_document(ScopedHandler *handler);

        static void failure_handler(ScopedHandler *handler);

        static const ScopedHandler::ElementStartFunctor &get_creator(
            const std::string & name) throw(std::runtime_error);

        static void scene_start_handler(
            const std::string & name,
            XMLHandler::AttributeMap & attributes,
            ScopedHandler *handler);

        static void color_start_handler(
            const std::string & name,
            XMLHandler::AttributeMap & attributes,
            ScopedHandler *handler);

        static void color_end_handler(
            const std::string & name,
            ScopedHandler* handler);

        static void layer_start_handler(
            const std::string & name,
            XMLHandler::AttributeMap & attributes,
            ScopedHandler *handler);

        static void layer_end_handler(
            const std::string & name,
            ScopedHandler* handler);

        static void external_start_handler(
            const std::string & name,
            XMLHandler::AttributeMap & attributes,
            ScopedHandler *handler) throw();


        static void include_start_handler(
            const std::string &name,
            XMLHandler::AttributeMap &attributes,
            ScopedHandler *handler);

        static void inject_start_handler(
            const std::string &name,
            XMLHandler::AttributeMap &attributes,
            ScopedHandler *handler);

        static void inject_end_handler(
            const std::string &name,
            ScopedHandler *handler);

    private:
        static HandlerInformer ms_scene_informer;
        static HandlerInformer ms_color_informer;
        static HandlerInformer ms_layer_informer;
        static HandlerInformer ms_external_informer;
        static HandlerInformer ms_include_informer;

        static std::set<boost::filesystem::path> ms_included_scenes;
    };
}


#endif // PEEKABOT_SCENE_FILE_LOADER_HH_INCLUDED
