/*
 * Copyright Staffan Gimåker 2006-2007, Anders Boberg 2006.
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <cstdlib>
#include <stdexcept>

#include "Sockets.hh"


void peekabot::sockets::set_nonblocking(peekabot::sockets::SocketType sock)
{
#ifdef _WIN32
    unsigned long nb = 1;
    ioctlsocket(sock, FIONBIO, &nb);
#else
    fcntl(sock, F_SETFL, O_NONBLOCK);
#endif
}

void peekabot::sockets::sockets_init()
{
#ifdef _WIN32
    WSADATA wsaData;
    if( WSAStartup(MAKEWORD(1, 1), &wsaData) != 0 )
        throw std::runtime_error("Fatal error: Couldn't initialize winsock");
#endif
}

void peekabot::sockets::sockets_cleanup()
{
#ifdef _WIN32
    WSACleanup();
#endif
}

int peekabot::sockets::get_socket_errno()
{
#ifdef _WIN32
    return WSAGetLastError();
#else
    return errno;
#endif
}
        
int peekabot::sockets::close_socket(peekabot::sockets::SocketType socket)
{
#ifdef _WIN32
    return closesocket(socket);
#else
    return ::close(socket);
#endif
}
