/*
 * Copyright Staffan Gimåker 2006-2007, 2009.
 * Anders Boberg 2006.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SOCKETS_HH
#define PEEKABOT_SOCKETS_HH


#include "Types.hh"


// Sockets on Windows are broken, here's the crap you need to make them usable..
#ifdef _WIN32
#    include <winsock.h>
#    include <winsock2.h>
#    define socklen_t int
#    ifndef EINPROGRESS
#      define EINPROGRESS WSAEINPROGRESS
#    endif
#    ifndef EINTR
#      define EINTR WSAEINTR
#    endif
#else
#    include <sys/select.h>
#    include <sys/socket.h>
#    include <sys/types.h>
#    include <unistd.h>
#    include <fcntl.h>
#    include <sys/time.h>
#    include <netinet/in.h>
#    include <netinet/tcp.h>
#    include <netdb.h>
#    include <arpa/inet.h>
#    include <errno.h>
#    define INVALID_SOCKET -1
#    define SOCKET_ERROR -1
#endif
//

#ifndef MSG_NOSIGNAL
#    define MSG_NOSIGNAL 0
#endif

namespace peekabot
{
    namespace sockets
    {
#ifdef _WIN32
        typedef SOCKET SocketType;
        typedef char* BufType;
#else
        typedef int SocketType;
        typedef void* BufType;
#endif

        void set_nonblocking(SocketType sock);

        void sockets_init();

        void sockets_cleanup();

        int get_socket_errno();

        int close_socket(SocketType socket);
    }
}

#endif // PEEKABOT_SOCKETS_HH
