/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "Subscriber.hh"


using namespace peekabot;



Subscriber::~Subscriber()
{
    SubscriptionSet subs;

    {
        boost::recursive_mutex::scoped_lock lock(m_mutex);
        
        subs = m_subscriptions;
    }

    for( SubscriptionSet::iterator it = subs.begin();
         it != subs.end(); ++it )
    {
        it->second->unsubscribe(it->first, this);
    }
}


void Subscriber::add_subscription(MessageType type, MessageHub *hub) throw()
{
    boost::recursive_mutex::scoped_lock lock(m_mutex);
    
    m_subscriptions.insert( std::make_pair(type, hub) );
}


void Subscriber::remove_subscription(MessageType type, MessageHub *hub) throw()
{
    boost::recursive_mutex::scoped_lock lock(m_mutex);
    
    m_subscriptions.erase( std::make_pair(type, hub) );
}
