/*
 * Copyright Staffan Gimåker 2009-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_UPLOAD_CACHE_HH_INCLUDED
#define PEEKABOT_UPLOAD_CACHE_HH_INCLUDED


#include <map>
#include <string>
#include <boost/utility.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/thread/recursive_mutex.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/cstdint.hpp>


namespace peekabot
{
    /**
     * \internal
     *
     *
     * This class is fully thread-safe.
     */
    class UploadCache : public boost::noncopyable
    {
    public:
        static boost::shared_ptr<UploadCache> create();

        ~UploadCache();

        void add_file(
            const std::string &remote_filename,
            const void *data, std::size_t n);

        void remove_file(const std::string &remote_filename);

        void clear();

        bool get_local_path(
            const std::string &remote_filename,
            boost::filesystem::path &local_path) const;

    private:
        UploadCache();

        static boost::filesystem::path get_upload_directory();

        boost::filesystem::path get_cache_directory() const;

        std::string generate_local_filename(
            const std::string &remote_filename);

    private:
        mutable boost::recursive_mutex m_mutex;

        typedef std::map<std::string, std::string> UploadMap;

        UploadMap m_files;

        boost::uint32_t m_counter;

        const boost::uint32_t m_cache_no;
    };
}


#endif // PEEKABOT_UPLOAD_CACHE_HH_INCLUDED
