/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <sstream>

#include "Version.hh"


using namespace peekabot;


std::string peekabot::make_peekabot_version_string(
    boost::uint8_t major,
    boost::uint8_t minor,
    boost::uint8_t rev,
    boost::uint8_t rc)
{
    std::stringstream ss;
    ss << (int)major << "." << (int)minor << "." << (int)rev;

    if( rc == 255 )
        ss << "-dev";
    else if( rc > 0 )
        ss << "-rc" << (int)rc;

    return ss.str();
}

const std::string peekabot::PEEKABOT_VERSION_STRING =
    make_peekabot_version_string(
        PEEKABOT_VERSION_MAJOR,
        PEEKABOT_VERSION_MINOR,
        PEEKABOT_VERSION_REVISION,
        PEEKABOT_RELEASE_STATUS);

const std::string peekabot::PEEKABOT_COMPATIBLE_VERSION_STRING =
    make_peekabot_version_string(
        PEEKABOT_COMPATIBLE_VERSION_MAJOR,
        PEEKABOT_COMPATIBLE_VERSION_MINOR,
        PEEKABOT_COMPATIBLE_VERSION_REVISION,
        0);

const std::string peekabot::PEEKABOT_PBAR_COMPATIBLE_VERSION_STRING =
    make_peekabot_version_string(
        PEEKABOT_PBAR_COMPATIBLE_VERSION_MAJOR,
        PEEKABOT_PBAR_COMPATIBLE_VERSION_MINOR,
        PEEKABOT_PBAR_COMPATIBLE_VERSION_REVISION,
        0);
