/*
 * Copyright Staffan Gimåker 2009-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_VERSION_HH_INCLUDED
#define PEEKABOT_VERSION_HH_INCLUDED


#include "Visibility.hh"

#include <string>
#include <boost/cstdint.hpp>


// Current peekabot version
#define PEEKABOT_VERSION_MAJOR    0
#define PEEKABOT_VERSION_MINOR    8
#define PEEKABOT_VERSION_REVISION 4
// Release status:
//   0   = final release
//   255 = dev
//   1   = RC 1
//   ...
#define PEEKABOT_RELEASE_STATUS   0

#define PEEKABOT_VERSION                        \
    ((PEEKABOT_VERSION_MAJOR << 16) |           \
     (PEEKABOT_VERSION_MINOR << 8)  |           \
     (PEEKABOT_VERSION_REVISION))

// The lowest version of peekabot clients this version is compatible with.
#define PEEKABOT_COMPATIBLE_VERSION_MAJOR    0
#define PEEKABOT_COMPATIBLE_VERSION_MINOR    8
#define PEEKABOT_COMPATIBLE_VERSION_REVISION 0

#define PEEKABOT_COMPATIBLE_VERSION                     \
    ((PEEKABOT_COMPATIBLE_VERSION_MAJOR << 16) |        \
     (PEEKABOT_COMPATIBLE_VERSION_MINOR << 8)  |        \
     (PEEKABOT_COMPATIBLE_VERSION_REVISION))

// The lowest version of peekabot this version can read PBAR files from.
// This can differ from the generally compatible version since the data flow is
// unidirectional, allowing us to be compatible with earlier version than
// possible for clients.
#define PEEKABOT_PBAR_COMPATIBLE_VERSION_MAJOR    0
#define PEEKABOT_PBAR_COMPATIBLE_VERSION_MINOR    8
#define PEEKABOT_PBAR_COMPATIBLE_VERSION_REVISION 0

#define PEEKABOT_PBAR_COMPATIBLE_VERSION                \
    ((PEEKABOT_PBAR_COMPATIBLE_VERSION_MAJOR << 16) |   \
     (PEEKABOT_PBAR_COMPATIBLE_VERSION_MINOR << 8)  |   \
     (PEEKABOT_PBAR_COMPATIBLE_VERSION_REVISION))


namespace peekabot
{
    PEEKABOT_API extern const std::string PEEKABOT_VERSION_STRING;
    PEEKABOT_API extern const std::string PEEKABOT_COMPATIBLE_VERSION_STRING;
    PEEKABOT_API extern const std::string PEEKABOT_PBAR_COMPATIBLE_VERSION_STRING;

    PEEKABOT_API std::string make_peekabot_version_string(
        boost::uint8_t major,
        boost::uint8_t minor,
        boost::uint8_t rev,
        boost::uint8_t rc);
}


#endif // PEEKABOT_VERSION_HH_INCLUDED
