/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_VISIBILITY_HH_INCLUDED
#define PEEKABOT_VISIBILITY_HH_INCLUDED


#if defined _WIN32 || defined __CYGWIN__
  #define PEEKABOT_HELPER_IMPORT __declspec(dllimport)
  #define PEEKABOT_HELPER_EXPORT __declspec(dllexport)
  #define PEEKABOT_HELPER_HIDDEN
#else
  #if defined __ELF__ && __GNUC__ >= 4
    #define PEEKABOT_HELPER_IMPORT __attribute__ ((visibility("default")))
    #define PEEKABOT_HELPER_EXPORT __attribute__ ((visibility("default")))
    #define PEEKABOT_HELPER_HIDDEN  __attribute__ ((visibility("hidden")))
  #else
    #define PEEKABOT_HELPER_IMPORT
    #define PEEKABOT_HELPER_EXPORT
    #define PEEKABOT_HELPER_HIDDEN
  #endif
#endif

#define PEEKABOT_HIDDEN PEEKABOT_HELPER_HIDDEN
#ifdef __PEEKABOT_CLIENT // defined when building the library
  #define PEEKABOT_API PEEKABOT_HELPER_EXPORT
#else
  #define PEEKABOT_API PEEKABOT_HELPER_IMPORT
#endif


#endif // PEEKABOT_VISIBILITY_HH_INCLUDED
