/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PEEKABOT_XML_PARSER_HH
#define __PEEKABOT_XML_PARSER_HH

#include <string>

namespace peekabot
{

    class XMLHandler;

    /**
     * \internal
     *
     * \brief Interface for SAX2 XML parsers.
     *
     * This class specifies two methods to be implemented by all XML parsers:
     * The \c set_handler() method used to specify which object will handle
     * parsing events, and the \c invoke() method, which  is called to start
     * processing a document using the current handler.
     */
    class XMLParser
    {
    public:
        virtual ~XMLParser() {}
        
        /** \brief Parse the specified document.
         *
         * \param filename The name of the XML document to parse.
         */
        virtual void invoke(const std::string& filename)
            throw(std::exception) = 0;
        
        /** \brief Set the \c XMLHandler that will receive all parsing events.
         *
         * \param handler A pointer to the handler that will receive events.
         */
        virtual void set_handler(XMLHandler *handler) = 0;
    };
    
    
    // kanske inte behvs, men...
    class XMLParserFactory
    {
    public:
        static XMLParser *create_parser();
    };

}

#endif //__PEEKABOT_XML_PARSER_HH
