/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "ActionMonitor.hh"
#include "../serialization/SmartPtrs.hh"

#ifdef __PEEKABOT_SERVER
#  include "MonitorReport.hh"
#  include "../ServerExecutionContext.hh"
#endif


using namespace peekabot;


ActionMonitor::ActionMonitor() throw()
{
}


ActionMonitor::ActionMonitor(
    boost::shared_ptr<Action> action,
    uint32_t request_id) throw()
    : m_request_id(request_id),
      m_action(action)
{
}


ActionMonitor::~ActionMonitor() throw()
{
}


Action *ActionMonitor::clone() const
{
    return new ActionMonitor(m_action, m_request_id);
}


void ActionMonitor::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    try
    {
        m_action->execute(context);

        Action *report = new MonitorReport(
            m_request_id, client::OPERATION_SUCCEEDED);

        context->post_response(report);
    }
    catch(std::exception &e)
    {
        Action *report = new MonitorReport(
            m_request_id,
            client::OPERATION_FAILED,
            e.what());

        context->post_response(report);

        // Re-throw the current exception
        throw;
    }
    catch(...)
    {
        Action *report = new MonitorReport(
            m_request_id,
            client::OPERATION_FAILED,
            "Unknown exception");

        context->post_response(report);

        // Re-throw the current exception
        throw;
    }
#endif
}


uint32_t ActionMonitor::get_request_id() const throw()
{
    return m_request_id;
}


boost::shared_ptr<Action> ActionMonitor::get_action()
{
    return m_action;
}


const boost::shared_ptr<Action> ActionMonitor::get_action() const
{
    return m_action;
}


void ActionMonitor::save(SerializationInterface &ar) const
{
    assert( m_action );
    ar << m_request_id << m_action;
}


void ActionMonitor::load(DeserializationInterface &ar)
{
    ar >> m_request_id >> m_action;
}
