/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_ACTION_MONITOR_HH_INCLUDED
#define PEEKABOT_ACTION_MONITOR_HH_INCLUDED


#include <exception>
#include <boost/shared_ptr.hpp>

#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    /**
     * \brief Monitors the outcome of an aggregated action and reports it
     * back to the proxy.
     *
     * \sa \c MonitorReport, \c OperationStatus, \c Status, \c ProxyImpl
     */
    class ActionMonitor : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        ActionMonitor(
            boost::shared_ptr<Action> action,
            uint32_t request_id) throw();

        virtual ~ActionMonitor() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

        uint32_t get_request_id() const throw();

        boost::shared_ptr<Action> get_action();

        const boost::shared_ptr<Action> get_action() const;

    protected:
        ActionMonitor() throw();

        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        uint32_t m_request_id;

        boost::shared_ptr<Action> m_action;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 28


#endif // PEEKABOT_ACTION_MONITOR_HH_INCLUDED
