/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <stdexcept>
#include "ActionResultContainer.hh"
#include "../serialization/Any.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../SceneObject.hh"
#else
#  include "../client/ClientExecutionContext.hh"
#endif


using namespace peekabot;


ActionResultContainer::ActionResultContainer(
    boost::uint32_t request_id,
    const Any &result) throw()
    : m_request_id(request_id),
      m_action_result(result)
{
}


ActionResultContainer::ActionResultContainer() throw()
{
}


ActionResultContainer::ActionResultContainer(
    const ActionResultContainer &x) throw()
    : m_request_id(x.m_request_id),
      m_action_result(x.m_action_result)
{
}


ActionResultContainer::~ActionResultContainer() throw()
{
}


Action *ActionResultContainer::clone() const
{
    return new ActionResultContainer(*this);
}


void ActionResultContainer::execute(
    ClientExecutionContext *context)
    const throw(std::exception)
{
#ifdef __PEEKABOT_CLIENT
    context->report_action_result(m_request_id, m_action_result);
#endif
}


void ActionResultContainer::save(SerializationInterface &ar) const
{
    ar << m_request_id << m_action_result;
}


void ActionResultContainer::load(DeserializationInterface &ar)
{
    ar >> m_request_id >> m_action_result;
}
