/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "AddObject.hh"
#include "serialization/Any.hh"
#include "serialization/Containers.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../SceneObject.hh"
#endif


using namespace peekabot;


AddObject::AddObject(
    const PathIdentifier &path_ident,
    NameConflictPolicy conflict_policy,
    ObjectID pseudonym_id,
    ObjectType type, const std::vector<Any> &args)
    : m_path_ident(path_ident),
      m_conflict_policy(conflict_policy),
      m_pseudonym_id(pseudonym_id),
      m_type(type),
      m_args(args)
{
}


Action *AddObject::clone() const
{
    return new AddObject(
        m_path_ident, m_conflict_policy, m_pseudonym_id, m_type, m_args);
}


void AddObject::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    std::string name = m_path_ident.get_leaf_name(context);
    SceneObject *parent = m_path_ident.get_parent(context);
    SceneObject *obj = 0;

    if( parent->has_child(name) && m_conflict_policy == ALIAS_ON_CONFLICT )
    {
        obj = parent->get_child(name);
    }
    else
    {
        try
        {
            obj = context->create_object(m_type, m_args);
            obj->set_name(name);
            parent->attach(obj, m_conflict_policy);
        }
        catch(...)
        {
            if( obj )
                delete obj;
            throw;
        }
    }

    context->register_pseudonym(obj->get_object_id(), m_pseudonym_id);
#endif
}


void AddObject::save(SerializationInterface &ar) const
{
    ar << m_path_ident << m_conflict_policy
       << m_pseudonym_id << m_type << m_args;
}


void AddObject::load(DeserializationInterface &ar)
{
    ar >> m_path_ident >> m_conflict_policy
       >> m_pseudonym_id >> m_type >> m_args;
}
