/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_ADD_OBJECT_HH_INCLUDED
#define PEEKABOT_ADD_OBJECT_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"
#include "../Any.hh"
#include "../PathIdentifier.hh"

#include <vector>


namespace peekabot
{
    class SceneObject;

    class AddObject : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        typedef std::vector<Any> Args;

        AddObject(
            const PathIdentifier &path_ident,
            NameConflictPolicy conflict_policy,
            ObjectID pseudonym_id,
            ObjectType type,
            const Args &args = Args());

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        AddObject() {}

    protected:
        virtual void save(SerializationInterface &ar) const;

        virtual void load(DeserializationInterface &ar);

    private:
        PathIdentifier m_path_ident;

        NameConflictPolicy m_conflict_policy;

        ObjectID m_pseudonym_id;

        ObjectType m_type;

        Args m_args;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 118


#endif // PEEKABOT_ADD_OBJECT_HH_INCLUDED
