/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "Assign.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../SceneObject.hh"
#endif

#include <cassert>
#include <stdexcept>


using namespace peekabot;


Assign::Assign(
    const PathIdentifier &path_ident,
    ObjectID pseudonym_id,
    ObjectType type)
    : m_path_ident(path_ident),
      m_pseudonym_id(pseudonym_id),
      m_type(type)
{
}


Action *Assign::clone() const
{
    return new Assign(m_path_ident, m_pseudonym_id, m_type);
}


void Assign::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    // Throws if the object is not found
    SceneObject *obj = m_path_ident.get_leaf(context);

    // Check type
    assert( obj );
    if( m_type <= 0xFFFF )
    {
        // m_type is a non-concrete type (scalable, vertex-based, etc.)
        if( !(obj->get_object_type() & m_type) )
            throw std::runtime_error("Incompatible types");
    }
    else
    {
        // m_type is a concrete, non-class type, e.g. a sphere object
        if( obj->get_object_type() != m_type )
            throw std::runtime_error("Incompatible types");
    }

    context->register_pseudonym(obj->get_object_id(), m_pseudonym_id);
#endif
}


void Assign::save(SerializationInterface &ar) const
{
    ar << m_path_ident << m_pseudonym_id << m_type;
}


void Assign::load(DeserializationInterface &ar)
{
    ar >> m_path_ident >> m_pseudonym_id >> m_type;
}
