/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_ASSIGN_HH_INCLUDED
#define PEEKABOT_ASSIGN_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"
#include "../PathIdentifier.hh"


namespace peekabot
{
    class Assign : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        Assign(
            const PathIdentifier &path_ident,
            ObjectID pseudonym_id,
            ObjectType type);

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        Assign() {}

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        PathIdentifier m_path_ident;

        ObjectID m_pseudonym_id;

        ObjectType m_type;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 119


#endif // PEEKABOT_ASSIGN_HH_INCLUDED
