/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <stdexcept>
#include "DeregisterPseudonym.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#endif


using namespace peekabot;


DeregisterPseudonym::DeregisterPseudonym() throw()
{
}


DeregisterPseudonym::DeregisterPseudonym(ObjectID id) throw()
    : m_pseudonym_id(id)
{
}


DeregisterPseudonym::~DeregisterPseudonym() throw()
{
}


Action *DeregisterPseudonym::clone() const
{
    return new DeregisterPseudonym(m_pseudonym_id);
}


void DeregisterPseudonym::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    context->deregister_pseudonym(m_pseudonym_id);
#endif
}


void DeregisterPseudonym::save(SerializationInterface &ar) const
{
    ar << m_pseudonym_id;
}

void DeregisterPseudonym::load(DeserializationInterface &ar)
{
    ar >> m_pseudonym_id;
}
