/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <stdexcept>
#include <vector>
#include <string>
#include "GetChildren.hh"
#include "../serialization/Containers.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../SceneObject.hh"
#  include "ActionResultContainer.hh"
#endif


using namespace peekabot;


GetChildren::GetChildren() throw()
{
}


GetChildren::GetChildren(uint32_t request_id, ObjectID target) throw()
    : m_request_id(request_id),
      m_target(target)
{
}


GetChildren::GetChildren(const GetChildren &x) throw()
    : m_request_id(x.m_request_id),
      m_target(x.m_target)
{
}


GetChildren::~GetChildren() throw()
{
}


Action *GetChildren::clone() const
{
    return new GetChildren(*this);
}


void GetChildren::execute(
    ServerExecutionContext *context)
    const throw(std::exception)
{
#ifdef __PEEKABOT_SERVER
    const SceneObject *ptr = context->get_object(m_target);

    if( !ptr )
        throw std::runtime_error(
            "Failed to get child names, target object not found.");

    std::vector<std::string> res;
    for( SceneObject::ConstChildIterator it = ptr->begin();
         it != ptr->end(); ++it )
        res.push_back((*it)->get_name());

    context->post_response(new ActionResultContainer(m_request_id, Any(res)));
#endif
}


void GetChildren::save(SerializationInterface &ar) const
{
    ar << m_request_id << m_target;
}

void GetChildren::load(DeserializationInterface &ar)
{
    ar >> m_request_id >> m_target;
}
