/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <stdexcept>
#include "GetPosition.hh"
#include "serialization/Types.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "ActionResultContainer.hh"
#  include "../SceneObject.hh"
#endif


using namespace peekabot;


GetPosition::GetPosition() throw()
{
}


GetPosition::GetPosition(
    uint32_t request_id,
    ObjectID target,
    CoordinateSystem coord_sys) throw()
    : m_request_id(request_id),
      m_target(target),
      m_coord_sys(coord_sys)
{
}


GetPosition::GetPosition(const GetPosition &x) throw()
    : m_request_id(x.m_request_id),
      m_target(x.m_target),
      m_coord_sys(x.m_coord_sys)
{
}


GetPosition::~GetPosition() throw()
{
}


Action *GetPosition::clone() const
{
    return new GetPosition(*this);
}


void GetPosition::execute(
    ServerExecutionContext *context)
    const throw(std::exception)
{
#ifdef __PEEKABOT_SERVER
    SceneObject *ptr = context->get_object(m_target);

    if( !ptr )
        throw std::runtime_error(
            "Failed to get position, target object not found.");

    Eigen::Vector3f pos;
    switch( m_coord_sys )
    {
        case PARENT_COORDINATES:
            pos = ptr->get_transformation().translation();
            break;

        case WORLD_COORDINATES:
            pos = ptr->get_mtow().translation();
            break;

        default:
            throw std::runtime_error(
                "Failed to get position: unsupported coordinate system");
            break;
    }

    Vector3 res(pos(0), pos(1), pos(2));
    context->post_response(new ActionResultContainer(m_request_id, Any(res)));
#endif
}


void GetPosition::save(SerializationInterface &ar) const
{
    ar << m_request_id << m_target << m_coord_sys;
}

void GetPosition::load(DeserializationInterface &ar)
{
    ar >> m_request_id >> m_target >> m_coord_sys;
}
